/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.concurrent;

import com.sap.sse.common.Named;
import com.sap.sse.concurrent.ConcurrentHashBag;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class NamedReentrantReadWriteLock
extends ReentrantReadWriteLock
implements Named {
    private static final long serialVersionUID = 2906084982209339774L;
    private final String name;
    private final String readLockName;
    private final String writeLockName;
    private final WriteLockWrapper writeLockWrapper;
    private final ReadLockWrapper readLockWrapper;
    private transient ConcurrentHashBag<Thread> readers;

    public NamedReentrantReadWriteLock(String name, boolean fair) {
        super(fair);
        this.name = name;
        this.readLockName = "readLock " + name;
        this.writeLockName = "writeLock " + name;
        this.writeLockWrapper = new WriteLockWrapper(super.writeLock());
        this.readLockWrapper = new ReadLockWrapper(super.readLock());
        this.readers = new ConcurrentHashBag();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.readers = new ConcurrentHashBag();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public ReentrantReadWriteLock.WriteLock writeLock() {
        return this.writeLockWrapper;
    }

    @Override
    public ReentrantReadWriteLock.ReadLock readLock() {
        return this.readLockWrapper;
    }

    public Iterable<Thread> getReaders() {
        return new ArrayList<Thread>(this.readers);
    }

    public Thread getWriter() {
        return this.getOwner();
    }

    @Override
    public String toString() {
        return "ReentrantReadWriteLock " + this.getName() + " (" + (this.isFair() ? "fair" : "unfair") + ")";
    }

    protected String getReadLockName() {
        return this.readLockName;
    }

    protected String getWriteLockName() {
        return this.writeLockName;
    }

    private class ReadLockWrapper
    extends ReentrantReadWriteLock.ReadLock {
        private static final long serialVersionUID = -4232071609936663619L;
        private final ReentrantReadWriteLock.ReadLock readLock;

        protected ReadLockWrapper(ReentrantReadWriteLock.ReadLock readLock) {
            super(NamedReentrantReadWriteLock.this);
            this.readLock = readLock;
        }

        @Override
        public void lock() {
            this.readLock.lock();
            NamedReentrantReadWriteLock.this.readers.add(Thread.currentThread());
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.readLock.lockInterruptibly();
            NamedReentrantReadWriteLock.this.readers.add(Thread.currentThread());
        }

        @Override
        public boolean tryLock() {
            boolean result = this.readLock.tryLock();
            if (result) {
                NamedReentrantReadWriteLock.this.readers.add(Thread.currentThread());
            }
            return result;
        }

        @Override
        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            boolean result = this.readLock.tryLock(timeout, unit);
            if (result) {
                NamedReentrantReadWriteLock.this.readers.add(Thread.currentThread());
            }
            return result;
        }

        @Override
        public void unlock() {
            this.readLock.unlock();
            NamedReentrantReadWriteLock.this.readers.remove(Thread.currentThread());
        }

        @Override
        public Condition newCondition() {
            return this.readLock.newCondition();
        }

        @Override
        public String toString() {
            return this.readLock.toString();
        }
    }

    private class WriteLockWrapper
    extends ReentrantReadWriteLock.WriteLock {
        private static final long serialVersionUID = -4234819025137348944L;
        private final ReentrantReadWriteLock.WriteLock writeLock;

        protected WriteLockWrapper(ReentrantReadWriteLock.WriteLock writeLock) {
            super(NamedReentrantReadWriteLock.this);
            this.writeLock = writeLock;
        }

        @Override
        public void lock() {
            this.writeLock.lock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.writeLock.lockInterruptibly();
        }

        @Override
        public boolean tryLock() {
            return this.writeLock.tryLock();
        }

        @Override
        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            return this.writeLock.tryLock(timeout, unit);
        }

        @Override
        public void unlock() {
            this.writeLock.unlock();
        }

        @Override
        public Condition newCondition() {
            return this.writeLock.newCondition();
        }

        @Override
        public String toString() {
            return this.writeLock.toString();
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return this.writeLock.isHeldByCurrentThread();
        }

        @Override
        public int getHoldCount() {
            return this.writeLock.getHoldCount();
        }
    }
}

