/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common.util;

import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;

public class BackoffTracker {
    private TimePoint backOffUntil;
    private final int backoffMultiplier;
    private Duration currentTimeout;
    private final Duration initialTimeout;
    private final Duration maxTimeout;

    public BackoffTracker(Duration initialTimeout, int backoffMultiplier) {
        this(initialTimeout, backoffMultiplier, Duration.ONE_MINUTE.times(5L));
    }

    public BackoffTracker(Duration initialTimeout, int backoffMultiplier, Duration maxTimeout) {
        this.initialTimeout = initialTimeout;
        this.backoffMultiplier = backoffMultiplier;
        this.maxTimeout = maxTimeout;
    }

    public synchronized void logFailure() {
        Duration newTimeOut;
        this.currentTimeout = this.currentTimeout == null ? this.initialTimeout : ((newTimeOut = this.currentTimeout.times(this.backoffMultiplier)).compareTo(this.maxTimeout) > 0 ? this.maxTimeout : newTimeOut);
        this.backOffUntil = TimePoint.now().plus(this.currentTimeout);
    }

    public synchronized boolean backOff() {
        return this.backOffUntil == null ? false : this.backOffUntil.after(TimePoint.now());
    }

    public synchronized void clear() {
        this.currentTimeout = null;
        this.backOffUntil = null;
    }
}

