/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common.settings.value;

import com.sap.sse.common.settings.generic.ValueConverter;
import com.sap.sse.common.settings.value.Value;
import com.sap.sse.common.settings.value.ValueCollection;
import java.util.Collection;

public abstract class ValueCollectionValue<C extends Collection<Value>>
implements ValueCollection {
    private static final long serialVersionUID = -5820765644801217519L;
    private C values;

    protected ValueCollectionValue(C values) {
        this.values = values;
    }

    protected abstract <T> Collection<T> emptyCollection();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Collection<T> getValues(ValueConverter<T> converter) {
        Collection<T> result = this.emptyCollection();
        C c = this.values;
        synchronized (c) {
            for (Value value : this.values) {
                result.add(converter.fromValue(value));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Value> getValueObjects() {
        Collection<Value> result = this.emptyCollection();
        C c = this.values;
        synchronized (c) {
            result.addAll((Collection<Value>)this.values);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void setValues(Iterable<T> values, ValueConverter<T> converter) {
        C c = this.values;
        synchronized (c) {
            this.clear();
            if (values != null) {
                for (T value : values) {
                    this.addValue(value, converter);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        C c = this.values;
        synchronized (c) {
            this.values.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void addValue(T value, ValueConverter<T> converter) {
        C c = this.values;
        synchronized (c) {
            this.addValue(converter.toValue(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void addValue(Value value) {
        C c = this.values;
        synchronized (c) {
            this.values.add((Value)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        C c = this.values;
        synchronized (c) {
            return this.values.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        C c = this.values;
        synchronized (c) {
            return this.values.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        C c = this.values;
        synchronized (c) {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        C c = this.values;
        synchronized (c) {
            block13: {
                ValueCollectionValue other;
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                if (this != obj) break block9;
                                return true;
                            }
                            if (obj != null) break block10;
                            return false;
                        }
                        if (this.getClass() == obj.getClass()) break block11;
                        return false;
                    }
                    other = (ValueCollectionValue)obj;
                    if (this.values != null) break block12;
                    if (other.values != null) {
                        return false;
                    }
                    break block13;
                }
                if (this.values.equals(other.values)) break block13;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        C c = this.values;
        synchronized (c) {
            return this.values.toString();
        }
    }
}

