/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common.settings.serializer;

import com.sap.sse.common.settings.Settings;
import com.sap.sse.common.settings.generic.GenericSerializableSettings;
import com.sap.sse.common.settings.generic.HasValueSetting;
import com.sap.sse.common.settings.generic.Setting;
import com.sap.sse.common.settings.generic.SettingsListSetting;
import com.sap.sse.common.settings.generic.SettingsMap;
import com.sap.sse.common.settings.generic.ValueCollectionSetting;
import com.sap.sse.common.settings.generic.ValueConverter;
import com.sap.sse.common.settings.generic.ValueSetting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SettingsToStringMapSerializer {
    private static final Logger LOG = Logger.getLogger(SettingsToStringMapSerializer.class.getName());
    private static final String ADDED_SUFFIX = ".added";
    private static final String REMOVED_SUFFIX = ".removed";

    public final Map<String, Iterable<String>> serialize(SettingsMap settingsMap) {
        HashMap<String, Iterable<String>> result = new HashMap<String, Iterable<String>>();
        this.serialize("", settingsMap, result);
        return result;
    }

    private void serialize(String prefix, SettingsMap settingsMap, Map<String, Iterable<String>> serialized) {
        for (Map.Entry<String, Settings> entry : settingsMap.getSettingsPerComponentId().entrySet()) {
            String key = entry.getKey();
            String childPrefix = key == null ? prefix : String.valueOf(prefix) + key + ".";
            Settings settings = entry.getValue();
            if (settings instanceof SettingsMap) {
                this.serialize(childPrefix, (SettingsMap)settings, serialized);
                continue;
            }
            if (!(settings instanceof GenericSerializableSettings)) continue;
            this.serialize(childPrefix, (GenericSerializableSettings)settings, serialized);
        }
    }

    public final Map<String, Iterable<String>> serialize(GenericSerializableSettings settings) {
        HashMap<String, Iterable<String>> result = new HashMap<String, Iterable<String>>();
        this.serialize("", settings, result);
        return result;
    }

    private void serialize(String prefix, GenericSerializableSettings settings, Map<String, Iterable<String>> serialized) {
        for (Map.Entry<String, Setting> entry : settings.getChildSettings().entrySet()) {
            Setting setting = entry.getValue();
            if (setting.isDefaultValue()) continue;
            String key = String.valueOf(prefix) + entry.getKey();
            this.serialize(key, setting, serialized);
        }
    }

    private void serialize(String key, Setting setting, Map<String, Iterable<String>> serialized) {
        if (setting instanceof ValueSetting) {
            serialized.put(key, this.serializeValueSetting(key, (ValueSetting)setting));
        } else if (setting instanceof ValueCollectionSetting) {
            this.serializeValueListSetting(key, serialized, (ValueCollectionSetting)setting);
        } else {
            String prefix = String.valueOf(key) + ".";
            if (setting instanceof GenericSerializableSettings) {
                this.serialize(prefix, (GenericSerializableSettings)setting, serialized);
            } else if (setting instanceof SettingsListSetting) {
                this.serializeSettingsListSetting(prefix, (SettingsListSetting)setting, serialized);
            } else {
                throw new IllegalStateException("Unknown Setting type");
            }
        }
    }

    private <T extends GenericSerializableSettings> void serializeSettingsListSetting(String prefix, SettingsListSetting<T> setting, Map<String, Iterable<String>> serialized) {
        int index = 0;
        for (GenericSerializableSettings childSettings : setting.getValues()) {
            String nestedPrefix = String.valueOf(prefix) + index + ".";
            this.serialize(nestedPrefix, childSettings, serialized);
            ++index;
        }
    }

    private <T> Iterable<String> serializeValueSetting(String key, ValueSetting<T> valueSetting) {
        return Collections.singleton(valueSetting.getValueConverter().toStringValue(valueSetting.getValue()));
    }

    private <T> Iterable<String> serializeValueListSetting(String key, Map<String, Iterable<String>> serialized, ValueCollectionSetting<T> valueSetting) {
        ArrayList<String> result = new ArrayList<String>();
        ValueConverter valueConverter = valueSetting.getValueConverter();
        serialized.put(String.valueOf(key) + ADDED_SUFFIX, this.serializeMultipleValuesForSetting(valueConverter, valueSetting.getAddedValues()));
        serialized.put(String.valueOf(key) + REMOVED_SUFFIX, this.serializeMultipleValuesForSetting(valueConverter, valueSetting.getRemovedValues()));
        return result;
    }

    private <T> Iterable<String> serializeMultipleValuesForSetting(ValueConverter<T> valueConverter, Iterable<T> values) {
        ArrayList<String> result = new ArrayList<String>();
        for (T value : values) {
            result.add(valueConverter.toStringValue(value));
        }
        return result;
    }

    public final <T extends SettingsMap> T deserializeSettingsMap(T settingsMap, Map<String, Iterable<String>> values) {
        Map<String, Map<String, Iterable<String>>> mappedInnerValues = this.mapNested(values);
        Set<Map.Entry<String, Settings>> childSettings = settingsMap.getSettingsPerComponentId().entrySet();
        for (Map.Entry<String, Settings> entry : childSettings) {
            Map<String, Iterable<String>> innerValues;
            String key = entry.getKey();
            Settings settings = entry.getValue();
            Map<String, Iterable<String>> map = innerValues = key == null ? values : mappedInnerValues.get(key.toString());
            if (innerValues == null) continue;
            if (settings instanceof SettingsMap) {
                this.deserializeSettingsMap((SettingsMap)settings, innerValues);
                continue;
            }
            if (!(settings instanceof GenericSerializableSettings)) continue;
            this.deserialize((GenericSerializableSettings)settings, innerValues);
        }
        return settingsMap;
    }

    public final <T extends GenericSerializableSettings> T deserialize(T settings, Map<String, Iterable<String>> values) {
        Map<String, Map<String, Iterable<String>>> mappedInnerValues = this.mapNested(values);
        for (Map.Entry<String, Setting> entry : settings.getChildSettings().entrySet()) {
            String key = entry.getKey();
            Setting setting = entry.getValue();
            this.deserialize(key, setting, values, mappedInnerValues);
        }
        return settings;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deserialize(String key, Setting setting, Map<String, Iterable<String>> values, Map<String, Map<String, Iterable<String>>> mappedInnerValues) {
        if (setting instanceof HasValueSetting) {
            Iterable<String> settingValues = values.get(key);
            if (setting instanceof ValueSetting) {
                if (settingValues == null) return;
                this.deserializeValueSetting((ValueSetting)setting, settingValues);
                return;
            } else {
                if (!(setting instanceof ValueCollectionSetting)) throw new IllegalStateException("Unknown HasValueSetting type");
                Iterable<String> addedValues = values.get(String.valueOf(key) + ADDED_SUFFIX);
                Iterable<String> removedValues = values.get(String.valueOf(key) + REMOVED_SUFFIX);
                this.deserializeValueListSetting((ValueCollectionSetting)setting, settingValues, addedValues, removedValues);
            }
            return;
        } else {
            Map<String, Iterable<String>> innerValues = mappedInnerValues.get(key);
            if (innerValues == null) return;
            if (setting instanceof GenericSerializableSettings) {
                this.deserialize((GenericSerializableSettings)setting, innerValues);
                return;
            } else {
                if (!(setting instanceof SettingsListSetting)) throw new IllegalStateException("Unknown Setting type");
                this.deserializeSettingsListSetting((SettingsListSetting)setting, innerValues);
            }
        }
    }

    private <T> void deserializeValueSetting(ValueSetting<T> valueSetting, Iterable<String> values) {
        Iterator<String> iterator = values.iterator();
        if (iterator.hasNext()) {
            ValueConverter valueConverter = valueSetting.getValueConverter();
            String stringValue = iterator.next();
            try {
                valueSetting.setValue(valueConverter.fromStringValue(stringValue));
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Error while converting String value \"" + stringValue + "\" using converter \"" + valueConverter.getClass().getSimpleName() + "\"", e);
            }
        }
    }

    private <T> void deserializeValueListSetting(ValueCollectionSetting<T> valueSetting, Iterable<String> values, Iterable<String> addedValues, Iterable<String> removedValues) {
        ValueConverter valueConverter = valueSetting.getValueConverter();
        if (values != null) {
            valueSetting.setValues(this.deserializeMultipleValuesForSetting(valueConverter, values));
        } else {
            Iterable addedSettingValues = this.deserializeMultipleValuesForSetting(valueConverter, addedValues);
            Iterable removedSettingValues = this.deserializeMultipleValuesForSetting(valueConverter, removedValues);
            valueSetting.setDiff(removedSettingValues, addedSettingValues);
        }
    }

    private <T> Iterable<T> deserializeMultipleValuesForSetting(ValueConverter<T> valueConverter, Iterable<String> values) {
        ArrayList<T> deserializedValues = new ArrayList<T>();
        if (values != null) {
            for (String stringValue : values) {
                try {
                    deserializedValues.add(valueConverter.fromStringValue(stringValue));
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Error while converting String value \"" + stringValue + "\" using converter \"" + valueConverter.getClass().getSimpleName() + "\"", e);
                }
            }
        }
        return deserializedValues;
    }

    private <T extends GenericSerializableSettings> void deserializeSettingsListSetting(SettingsListSetting<T> valueSetting, Map<String, Iterable<String>> values) {
        Map<String, Map<String, Iterable<String>>> mappedNestedListValues = this.mapNestedWithIndexOrder(values);
        ArrayList<GenericSerializableSettings> deserializedValues = new ArrayList<GenericSerializableSettings>();
        for (Map.Entry<String, Map<String, Iterable<String>>> entry : mappedNestedListValues.entrySet()) {
            deserializedValues.add(this.deserialize((GenericSerializableSettings)valueSetting.getSettingsFactory().newInstance(), entry.getValue()));
        }
        valueSetting.setValues(deserializedValues);
    }

    private Map<String, Map<String, Iterable<String>>> mapNestedWithIndexOrder(Map<String, Iterable<String>> values) {
        TreeMap<String, Map<String, Iterable<String>>> result = new TreeMap<String, Map<String, Iterable<String>>>(new IndexComparator());
        result.putAll(this.mapNested(values));
        return result;
    }

    private Map<String, Map<String, Iterable<String>>> mapNested(Map<String, Iterable<String>> values) {
        HashMap<String, Map<String, Iterable<String>>> result = new HashMap<String, Map<String, Iterable<String>>>();
        for (Map.Entry<String, Iterable<String>> entry : values.entrySet()) {
            String key = entry.getKey();
            int separatorIndex = key.indexOf(".");
            if (separatorIndex <= 0) continue;
            String group = key.substring(0, separatorIndex);
            String nestedKey = key.substring(separatorIndex + 1);
            HashMap<String, Iterable<String>> inner = (HashMap<String, Iterable<String>>)result.get(group);
            if (inner == null) {
                inner = new HashMap<String, Iterable<String>>();
                result.put(group, inner);
            }
            inner.put(nestedKey, entry.getValue());
        }
        return result;
    }

    private static class IndexComparator
    implements Comparator<String> {
        private IndexComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            boolean o1error = false;
            boolean o2error = false;
            int o1int = 0;
            int o2int = 0;
            try {
                o1int = Integer.parseInt(o1);
            }
            catch (NumberFormatException e) {
                o1error = true;
            }
            try {
                o2int = Integer.parseInt(o2);
            }
            catch (NumberFormatException e) {
                o1error = true;
            }
            if (o1error && o2error) {
                return o1.compareTo(o2);
            }
            if (!o1error && !o2error) {
                return Integer.compare(o1int, o2int);
            }
            return o1error ? 1 : -1;
        }
    }
}

