/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common.settings.generic;

import com.sap.sse.common.settings.GwtIncompatible;
import com.sap.sse.common.settings.generic.AbstractSetting;
import com.sap.sse.common.settings.generic.GenericSerializableSettings;
import com.sap.sse.common.settings.generic.Setting;
import com.sap.sse.common.settings.generic.SettingsList;
import com.sap.sse.common.settings.value.SettingsValue;
import com.sap.sse.common.settings.value.Value;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractGenericSerializableSettings
extends AbstractSetting
implements GenericSerializableSettings {
    private static final long serialVersionUID = -415371632804540785L;
    protected SettingsValue value;
    protected transient Map<String, Setting> childSettings;

    public AbstractGenericSerializableSettings() {
        this.value = new SettingsValue();
        this.addChildSettingsInternal();
    }

    public AbstractGenericSerializableSettings(String name, AbstractGenericSerializableSettings settings) {
        super(name, settings);
        this.value = (SettingsValue)settings.getValue(name);
        if (this.value == null) {
            this.value = new SettingsValue();
            settings.setValue(name, this.value);
        }
        this.addChildSettingsInternal();
    }

    protected void adoptValue(SettingsValue value) {
        this.value = value;
        if (this.childSettings != null) {
            for (Map.Entry<String, Setting> entry : this.childSettings.entrySet()) {
                Value childValue;
                Setting childSetting = entry.getValue();
                if (childSetting instanceof AbstractGenericSerializableSettings && (childValue = value.getValue(entry.getKey())) != null) {
                    ((AbstractGenericSerializableSettings)childSetting).adoptValue((SettingsValue)childValue);
                }
                if (!(childSetting instanceof SettingsList) || (childValue = value.getValue(entry.getKey())) == null) continue;
                ((SettingsList)childSetting).adoptValue();
            }
        }
    }

    protected SettingsValue getInnerValueObject() {
        return this.value;
    }

    protected final void addChildSettingsInternal() {
        if (this.childSettings == null) {
            this.childSettings = new HashMap<String, Setting>();
            this.addChildSettings();
        }
    }

    protected abstract void addChildSettings();

    public Value getValue(String settingName) {
        return this.value.getValue(settingName);
    }

    public void setValue(String settingName, Value value) {
        this.value.setValue(settingName, value);
    }

    protected void addSetting(String name, Setting setting) {
        if (name.contains(".")) {
            throw new IllegalArgumentException("\".\" is currently not allowed for setting names");
        }
        if (this.childSettings.containsKey(name)) {
            throw new IllegalArgumentException("setting with name " + name + " already added to setting type " + this.getClass().getSimpleName());
        }
        this.childSettings.put(name, setting);
    }

    @Override
    public boolean isDefaultValue() {
        for (Setting setting : this.childSettings.values()) {
            if (setting.isDefaultValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void resetToDefault() {
        for (Setting setting : this.childSettings.values()) {
            setting.resetToDefault();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Setting> getChildSettings() {
        Map<String, Setting> map = this.childSettings;
        synchronized (map) {
            return new HashMap<String, Setting>(this.childSettings);
        }
    }

    @GwtIncompatible
    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.addChildSettingsInternal();
    }

    @GwtIncompatible
    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{(").append(this.getClass().getSimpleName()).append(")");
        boolean first = true;
        for (Map.Entry<String, Setting> childSetting : this.childSettings.entrySet()) {
            if (!first) {
                sb.append("; ");
            }
            sb.append(String.valueOf(childSetting.getKey()) + "=" + childSetting.getValue());
            first = false;
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.childSettings == null ? 0 : this.childSettings.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractGenericSerializableSettings other = (AbstractGenericSerializableSettings)obj;
        return !(this.childSettings == null ? other.childSettings != null : !this.childSettings.equals(other.childSettings));
    }
}

