/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common.media;

import com.sap.sse.common.media.MediaSubType;
import com.sap.sse.common.media.MediaType;

public enum MimeType {
    mp4(MediaType.video, MediaSubType.mp4, "mp4"),
    ogv(MediaType.video, MediaSubType.ogg, "ogv"),
    qt(MediaType.video, MediaSubType.mp4, "qt|qtvr|qti|qtif"),
    mp3(MediaType.audio, MediaSubType.mpeg, "mp3"),
    ogg(MediaType.audio, MediaSubType.ogg, "ogg|oga|spx"),
    aac(MediaType.audio, MediaSubType.aac, "acc"),
    webm(MediaType.video, MediaSubType.webm, "webm"),
    youtube(MediaType.video, MediaSubType.youtube, ""),
    vimeo(MediaType.video, MediaSubType.vimeo, ""),
    image(MediaType.image, MediaSubType.unknown, "jpg|jpeg|jpe|jif|jfif|jfi|png|gif|webp|tiff|tif|apng|avif|svg|bmp|ico|cur"),
    unknown(MediaType.unknown, MediaSubType.unknown, ""),
    mp4panorama(MediaType.video, MediaSubType.mp4, "mp4"),
    mp4panoramaflip(MediaType.video, MediaSubType.mp4, "mp4"),
    mov(MediaType.video, MediaSubType.mp4, "mov|quicktime");

    private static final String YOUTUBE_REGEX = "((http(s)?:\\/\\/)?)(www\\.)?((youtube\\.com\\/)|(youtu.be\\/))[\\S]+";
    public static final String VIMEO_REGEX = "(?:http|https)?:?\\/?\\/?(?:www\\.)?(?:player\\.)?vimeo\\.com\\/(?:channels\\/(?:\\w+\\/)?|groups\\/(?:[^\\/]*)\\/videos\\/|video\\/|)(\\d+)(?:|\\/\\?)";
    public final MediaType mediaType;
    public final MediaSubType mediaSubType;
    public final String endingPattern;

    private MimeType(MediaType mediaType, MediaSubType mediaSubType, String endingPattern) {
        this.mediaType = mediaType;
        this.mediaSubType = mediaSubType;
        this.endingPattern = endingPattern;
    }

    public boolean isPanorama() {
        return this == mp4panorama || this == mp4panoramaflip;
    }

    public boolean isFlippedPanorama() {
        return this == mp4panoramaflip;
    }

    public String getEndingPattern() {
        return this.endingPattern;
    }

    public boolean isImage() {
        return this.mediaType == MediaType.image;
    }

    public boolean isVideo() {
        return this.mediaType == MediaType.video;
    }

    public MediaSubType getMediaSubType() {
        return this.mediaSubType;
    }

    public String toString() {
        return String.valueOf(this.mediaType.name()) + '/' + this.mediaSubType.toString();
    }

    public static MimeType byName(String mimeTypeName) {
        try {
            if (mimeTypeName != null) {
                return MimeType.valueOf(mimeTypeName);
            }
            return null;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static MimeType[] mp4MimeTypes() {
        return new MimeType[]{mp4, mp4panorama, mp4panoramaflip, mov};
    }

    public static MimeType byExtension(String fileName) {
        MimeType result;
        if (fileName == null) {
            result = unknown;
        } else {
            int dotPos = fileName.trim().lastIndexOf(46);
            if (dotPos >= 0) {
                String fileEnding = fileName.trim().substring(dotPos + 1).toLowerCase();
                MimeType bestMatch = unknown;
                if (fileEnding != null) {
                    MimeType[] mimeTypeArray = MimeType.values();
                    int n = mimeTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        boolean matchFound;
                        MimeType mimeType = mimeTypeArray[n2];
                        if (!mimeType.getEndingPattern().isEmpty() && (matchFound = fileEnding.toLowerCase().matches(mimeType.endingPattern))) {
                            bestMatch = mimeType;
                            break;
                        }
                        ++n2;
                    }
                }
                result = bestMatch;
            } else {
                result = unknown;
            }
        }
        return result;
    }

    public static MimeType extractFromUrl(String url) {
        MimeType mimeType = url == null ? unknown : (url.trim().matches(YOUTUBE_REGEX) ? youtube : (url.trim().matches(VIMEO_REGEX) ? vimeo : MimeType.byExtension(url)));
        return mimeType;
    }

    public static MimeType byContentType(String contentType) {
        MimeType result;
        if (contentType != null && contentType.contains("/")) {
            String mediaType = contentType.split("/")[0];
            String subType = contentType.split("/")[1];
            MimeType bestMatch = unknown;
            MimeType[] mimeTypeArray = MimeType.values();
            int n = mimeTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                MimeType mimeType = mimeTypeArray[n2];
                if (mimeType.mediaType.name().equals(mediaType) && (mimeType.name().equals(subType) || mimeType.getEndingPattern().contains(subType.toLowerCase()) || mimeType.getMediaSubType().name().equals(subType))) {
                    bestMatch = mimeType;
                    break;
                }
                ++n2;
            }
            result = bestMatch;
        } else {
            result = unknown;
        }
        return result;
    }
}

