/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common.impl;

import com.sap.sse.common.Duration;
import com.sap.sse.common.impl.AbstractDuration;

public class MillisecondsDurationImpl
extends AbstractDuration {
    private static final long serialVersionUID = -4257982564719184723L;
    private final long millis;

    public MillisecondsDurationImpl(long millis) {
        this.millis = millis;
    }

    @Override
    public long asMillis() {
        return this.millis;
    }

    @Override
    public Duration abs() {
        return this.millis >= 0L ? this : new MillisecondsDurationImpl(-this.millis);
    }

    @Override
    public double asSeconds() {
        return (double)this.asMillis() / 1000.0;
    }

    @Override
    public Duration divide(long divisor) {
        return new MillisecondsDurationImpl(this.asMillis() / divisor);
    }

    @Override
    public Duration divide(double divisor) {
        return new MillisecondsDurationImpl((long)(1.0 / divisor * (double)this.asMillis()));
    }

    @Override
    public double divide(Duration duration) {
        return (double)this.asMillis() / (double)duration.asMillis();
    }

    @Override
    public Duration times(long factor) {
        return new MillisecondsDurationImpl(this.asMillis() * factor);
    }

    @Override
    public Duration times(double factor) {
        return new MillisecondsDurationImpl((long)(factor * (double)this.asMillis()));
    }

    @Override
    public double asMinutes() {
        return this.asSeconds() / 60.0;
    }

    @Override
    public double asHours() {
        return (double)this.asMillis() / (double)Duration.ONE_HOUR.asMillis();
    }

    @Override
    public double asDays() {
        return this.asMillis() / Duration.ONE_DAY.asMillis();
    }

    @Override
    public Duration minus(Duration duration) {
        return new MillisecondsDurationImpl(this.asMillis() - duration.asMillis());
    }

    @Override
    public Duration minus(long milliseconds) {
        return new MillisecondsDurationImpl(this.asMillis() - milliseconds);
    }

    @Override
    public Duration plus(long milliseconds) {
        return new MillisecondsDurationImpl(this.asMillis() + milliseconds);
    }

    @Override
    public Duration plus(Duration duration) {
        return new MillisecondsDurationImpl(this.asMillis() + duration.asMillis());
    }

    @Override
    public int compareTo(Duration o) {
        long diff = this.asMillis() - o.asMillis();
        return diff > 0L ? 1 : (diff < 0L ? -1 : 0);
    }

    public int hashCode() {
        return (int)(this.asMillis() & Integer.MAX_VALUE);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Duration) {
            return this.compareTo((Duration)obj) == 0;
        }
        return false;
    }

    @Override
    public Duration mod(Duration d) {
        return new MillisecondsDurationImpl(this.asMillis() % d.asMillis());
    }
}

