/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common.impl;

import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.impl.SerializableComparator;
import java.util.Comparator;
import java.util.Date;

public abstract class AbstractTimePoint
implements TimePoint {
    private static final long serialVersionUID = 8825508619301420378L;
    public static Comparator<TimePoint> TIMEPOINT_COMPARATOR = new SerializableComparator<TimePoint>(){
        private static final long serialVersionUID = 7644726881387366025L;

        @Override
        public int compare(TimePoint o1, TimePoint o2) {
            long o2Millis;
            long o1Millis = o1.asMillis();
            return o1Millis < (o2Millis = o2.asMillis()) ? -1 : (o1Millis == o2Millis ? 0 : 1);
        }
    };

    @Override
    public int compareTo(TimePoint o) {
        return TIMEPOINT_COMPARATOR.compare(this, o);
    }

    @Override
    public Date asDate() {
        Date result = this.getDateFromCache();
        if (result == null) {
            result = new Date(this.asMillis());
            this.cacheDate(result);
        }
        return result;
    }

    @Override
    public TimePoint plus(Duration duration) {
        TimePoint result = duration != null ? this.plus(duration.asMillis()) : this;
        return result;
    }

    @Override
    public TimePoint minus(Duration duration) {
        TimePoint result = duration != null ? this.minus(duration.asMillis()) : this;
        return result;
    }

    @Override
    public Duration until(TimePoint later) {
        return new MillisecondsDurationImpl(later.asMillis() - this.asMillis());
    }

    @Override
    public TimePoint plus(long milliseconds) {
        TimePoint result = milliseconds > 0L ? (EndOfTime.asMillis() - milliseconds >= this.asMillis() ? new MillisecondsTimePoint(this.asMillis() + milliseconds) : EndOfTime) : (this.asMillis() < milliseconds ? BeginningOfTime : new MillisecondsTimePoint(this.asMillis() + milliseconds));
        return result;
    }

    @Override
    public TimePoint minus(long milliseconds) {
        return this.plus(-milliseconds);
    }

    @Override
    public boolean after(TimePoint other) {
        return this.compareTo(other) > 0;
    }

    @Override
    public boolean before(TimePoint other) {
        return this.compareTo(other) < 0;
    }

    public int hashCode() {
        return (int)(this.asMillis() & Integer.MAX_VALUE);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TimePoint) {
            return this.compareTo((TimePoint)obj) == 0;
        }
        return false;
    }

    public String toString() {
        long millis = this.asMillis() % 1000L;
        String fullSeconds = this.asDate().toString();
        String result = millis == 0L ? fullSeconds : String.valueOf(fullSeconds) + " (+" + millis + "ms)";
        return result;
    }

    protected Date getDateFromCache() {
        return null;
    }

    protected void cacheDate(Date date) {
    }

    @Override
    public TimePoint getNearestModuloOneMinute(TimePoint syncToClosestSecondsAndMillisOf) {
        Duration diffModOneMinute = this.until(syncToClosestSecondsAndMillisOf).mod(Duration.ONE_MINUTE);
        Duration diffToAdd = diffModOneMinute.compareTo(Duration.ONE_SECOND.times(30L)) > 0 ? Duration.ONE_MINUTE.minus(diffModOneMinute).times(-1L) : (diffModOneMinute.compareTo(Duration.ONE_SECOND.times(-30L)) < 0 ? Duration.ONE_MINUTE.minus(diffModOneMinute.times(-1L)) : diffModOneMinute);
        TimePoint result = this.plus(diffToAdd);
        assert (this.until(result).abs().compareTo(Duration.ONE_SECOND.times(30L)) <= 0);
        assert (syncToClosestSecondsAndMillisOf.asMillis() % 60000L == result.asMillis() % 60000L);
        return result;
    }
}

