/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common.filter.impl;

import com.sap.sse.common.Util;

public abstract class KeywordMatcher<T> {
    public abstract Iterable<String> getStrings(T var1);

    public boolean matches(Iterable<String> keywords, T t) {
        boolean matchesOrNoKeywords = keywords == null || Util.isEmpty(keywords) || this.containsText(t, keywords);
        return matchesOrNoKeywords;
    }

    public boolean matchesExactly(Iterable<String> keywords, T t) {
        return keywords != null && this.matches(t, keywords, true);
    }

    private boolean containsText(T obj, Iterable<String> keywords) {
        return this.matches(obj, keywords, false);
    }

    private boolean matches(T obj, Iterable<String> keywords, boolean exactMatch) {
        boolean failed = false;
        for (String word : keywords) {
            String textAsUppercase = word.toUpperCase();
            failed = true;
            for (String s : this.getStrings(obj)) {
                if (!this.matches(s, textAsUppercase, exactMatch)) continue;
                failed = false;
                break;
            }
            if (!failed) continue;
            return false;
        }
        return true;
    }

    private boolean matches(String s, String keyword, boolean exactMatch) {
        return s != null && (exactMatch ? s.equalsIgnoreCase(keyword) : s.toUpperCase().contains(keyword));
    }
}

