/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common.filter;

import com.sap.sse.common.filter.FilterOperator;

public class TextOperator
implements FilterOperator<String> {
    private Operators operator;

    public TextOperator(Operators operator) {
        this.operator = operator;
    }

    public Operators getOperator() {
        return this.operator;
    }

    public void setOperator(Operators operator) {
        if (operator != null) {
            this.operator = operator;
        }
    }

    @Override
    public boolean matchValues(String filterValue, String valueToMatch) {
        switch (this.operator) {
            case Contains: {
                return valueToMatch.indexOf(filterValue) >= 0;
            }
            case Equals: {
                return valueToMatch.equals(filterValue);
            }
            case NotContains: {
                return valueToMatch.indexOf(filterValue) < 0;
            }
            case NotEqualTo: {
                return !valueToMatch.equals(filterValue);
            }
            case EndsWith: {
                return valueToMatch.endsWith(filterValue);
            }
            case StartsWith: {
                return valueToMatch.startsWith(filterValue);
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return this.operator.name();
    }

    public static enum Operators {
        Equals,
        NotEqualTo,
        Contains,
        NotContains,
        StartsWith,
        EndsWith;

    }
}

