/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common.filter;

import com.sap.sse.common.filter.Filter;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class FilterSet<FilterObjectType, T extends Filter<FilterObjectType>> {
    private String name;
    private final Set<T> filters;
    private boolean editable;

    public FilterSet(String name) {
        this.name = name;
        this.editable = true;
        this.filters = new LinkedHashSet<T>();
    }

    public boolean addFilter(T filter) {
        return this.filters.add(filter);
    }

    public boolean removeFilter(T filter) {
        return this.filters.remove(filter);
    }

    public Set<T> getFilters() {
        return Collections.unmodifiableSet(this.filters);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }
}

