/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common;

import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;

public class TimingStats {
    private final Map<Duration, AtomicLong> agesForAveragesAndTheirDurationSumsInMillis;
    private final ConcurrentSkipListSet<LogEntry> logEntries;
    private AtomicLong idCounter;
    private TimePoint lastNow;

    public TimingStats(Duration ... agesForAverages) {
        this(MillisecondsTimePoint.now(), agesForAverages);
    }

    TimingStats(TimePoint now, Duration ... agesForAverages) {
        if (agesForAverages.length == 0) {
            throw new IllegalArgumentException("At least one age must be provided");
        }
        this.lastNow = now;
        this.idCounter = new AtomicLong(0L);
        this.agesForAveragesAndTheirDurationSumsInMillis = new HashMap<Duration, AtomicLong>();
        Duration[] durationArray = agesForAverages;
        int n = agesForAverages.length;
        int n2 = 0;
        while (n2 < n) {
            Duration ageForAverages = durationArray[n2];
            this.agesForAveragesAndTheirDurationSumsInMillis.put(ageForAverages, new AtomicLong(0L));
            ++n2;
        }
        this.logEntries = new ConcurrentSkipListSet();
    }

    public void recordTiming(TimePoint when, Duration howLong) {
        TimePoint newNow = MillisecondsTimePoint.now();
        this.recordTiming(newNow, when, howLong);
    }

    void recordTiming(TimePoint newNow, TimePoint when, Duration howLong) {
        this.updateStatsBasedOnNewNow(newNow);
        Duration ageOfNewEntry = when.until(newNow);
        this.logEntries.add(new LogEntry(when, howLong, this.idCounter.getAndIncrement()));
        for (Map.Entry<Duration, AtomicLong> e : this.agesForAveragesAndTheirDurationSumsInMillis.entrySet()) {
            if (ageOfNewEntry.compareTo(e.getKey()) > 0) continue;
            e.getValue().addAndGet(howLong.asMillis());
        }
    }

    private void updateStatsBasedOnNewNow(TimePoint newNow) {
        if (newNow.after(this.lastNow)) {
            Duration oldestAge = Duration.NULL;
            for (Map.Entry<Duration, AtomicLong> e : this.agesForAveragesAndTheirDurationSumsInMillis.entrySet()) {
                TimePoint removeIntervalEnd;
                TimePoint removeIntervalStart;
                if (e.getKey().compareTo(oldestAge) > 0) {
                    oldestAge = e.getKey();
                }
                if (!(removeIntervalStart = this.lastNow.minus(e.getKey())).before(removeIntervalEnd = newNow.minus(e.getKey()))) continue;
                for (LogEntry entrySkippingToNext : this.logEntries.subSet(this.timePointLogEntry(removeIntervalStart), true, this.timePointLogEntry(removeIntervalEnd), false)) {
                    e.getValue().addAndGet(-entrySkippingToNext.getHowLong().asMillis());
                }
            }
            Iterator<LogEntry> removingIter = this.logEntries.headSet(this.timePointLogEntry(newNow.minus(oldestAge)), false).iterator();
            while (removingIter.hasNext()) {
                removingIter.next();
                removingIter.remove();
            }
            this.lastNow = newNow;
        }
    }

    public Map<Duration, Util.Pair<Duration, Integer>> getAverageDurationsAndNumberOfRequests() {
        TimePoint now = MillisecondsTimePoint.now();
        return this.getAverageDurations(now);
    }

    Map<Duration, Util.Pair<Duration, Integer>> getAverageDurations(TimePoint now) {
        this.updateStatsBasedOnNewNow(now);
        LogEntry dummyLogEntryForNow = this.timePointLogEntry(now);
        HashMap<Duration, Util.Pair<Duration, Integer>> result = new HashMap<Duration, Util.Pair<Duration, Integer>>();
        Iterator<Map.Entry<Duration, AtomicLong>> iterator = this.agesForAveragesAndTheirDurationSumsInMillis.entrySet().iterator();
        while (iterator.hasNext()) {
            int eventCount;
            Map.Entry<Duration, AtomicLong> e;
            result.put(e.getKey(), new Util.Pair<MillisecondsDurationImpl, Integer>((eventCount = this.logEntries.subSet(this.timePointLogEntry(now.minus((e = iterator.next()).getKey())), true, dummyLogEntryForNow, true).size()) == 0 ? null : new MillisecondsDurationImpl(e.getValue().get() / (long)eventCount), eventCount));
        }
        return result;
    }

    private LogEntry timePointLogEntry(TimePoint when) {
        return new LogEntry(when, null, 0L);
    }

    private static class LogEntry
    implements Comparable<LogEntry> {
        private final TimePoint when;
        private final Duration howLong;
        private final long id;

        public LogEntry(TimePoint when, Duration howLong, long id) {
            this.when = when;
            this.howLong = howLong;
            this.id = id;
        }

        public TimePoint getWhen() {
            return this.when;
        }

        public Duration getHowLong() {
            return this.howLong;
        }

        public long getId() {
            return this.id;
        }

        @Override
        public int compareTo(LogEntry o) {
            int result = this.getWhen().compareTo(o.getWhen());
            if (result == 0) {
                result = Long.compare(this.getId(), o.getId());
            }
            return result;
        }

        public String toString() {
            return "LogEntry [when=" + this.when + ", howLong=" + this.howLong + ", id=" + this.id + "]";
        }
    }
}

