/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common;

import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.datamining.annotations.Dimension;
import com.sap.sse.datamining.annotations.Statistic;
import java.io.Serializable;

public interface Speed
extends Comparable<Speed>,
Serializable {
    public static final Speed NULL = new Speed(){
        private static final long serialVersionUID = 1448378212070589610L;

        @Override
        public int compareTo(Speed o) {
            return this.getMetersPerSecond() > o.getMetersPerSecond() ? 1 : (this.getMetersPerSecond() == o.getMetersPerSecond() ? 0 : -1);
        }

        @Override
        public double getKnots() {
            return 0.0;
        }

        @Override
        public double getMetersPerSecond() {
            return 0.0;
        }

        @Override
        public double getKilometersPerHour() {
            return 0.0;
        }

        @Override
        public double getBeaufort() {
            return 0.0;
        }

        @Override
        public Distance travel(TimePoint from, TimePoint to) {
            return Distance.NULL;
        }

        @Override
        public Duration getDuration(Distance distance) {
            throw new ArithmeticException("Cannot determine duration for any distance with zero speed");
        }

        public String toString() {
            return "0kn";
        }

        @Override
        public double getStatuteMilesPerHour() {
            return 0.0;
        }

        @Override
        public Distance travel(Duration duration) {
            return Distance.NULL;
        }

        @Override
        public double divide(Speed speed) {
            return 0.0;
        }

        @Override
        public Speed scale(double d) {
            return this;
        }
    };

    @Statistic(messageKey="speedInKnots", resultDecimals=2)
    public double getKnots();

    @Dimension(messageKey="speedInFullKnots")
    default public int getKnotsFloored() {
        return (int)Math.round(this.getKnots());
    }

    public double getMetersPerSecond();

    public double getKilometersPerHour();

    public double getBeaufort();

    public double getStatuteMilesPerHour();

    public Distance travel(TimePoint var1, TimePoint var2);

    public Duration getDuration(Distance var1);

    public Distance travel(Duration var1);

    public double divide(Speed var1);

    public Speed scale(double var1);
}

