/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common;

import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.common.impl.SecondsDurationImpl;
import java.io.Serializable;

public interface Duration
extends Serializable,
Comparable<Duration> {
    public static final Duration NULL = new MillisecondsDurationImpl(0L);
    public static final Duration ONE_MILLISECOND = new MillisecondsDurationImpl(1L);
    public static final Duration ONE_SECOND = new MillisecondsDurationImpl(1000L);
    public static final Duration ONE_MINUTE = ONE_SECOND.times(60L);
    public static final Duration ONE_HOUR = ONE_MINUTE.times(60L);
    public static final Duration ONE_DAY = ONE_HOUR.times(24L);
    public static final Duration ONE_WEEK = ONE_DAY.times(7L);
    public static final Duration ONE_YEAR = ONE_DAY.times(365L);
    public static final Duration FOREVER = new MillisecondsDurationImpl(Long.MAX_VALUE);

    public static Duration ofMillis(long millis) {
        return new MillisecondsDurationImpl(millis);
    }

    public static Duration ofSeconds(double seconds) {
        return new SecondsDurationImpl(seconds);
    }

    public long asMillis();

    public double asSeconds();

    public double asMinutes();

    public double asHours();

    public double asDays();

    public Duration abs();

    public Duration divide(long var1);

    public Duration divide(double var1);

    public double divide(Duration var1);

    public Duration times(long var1);

    public Duration times(double var1);

    public Duration minus(Duration var1);

    public Duration minus(long var1);

    public Duration plus(long var1);

    public Duration plus(Duration var1);

    public Duration mod(Duration var1);
}

