/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.news.impl;

import com.sap.sailing.domain.base.Event;
import com.sap.sailing.news.EventNewsItem;
import com.sap.sailing.news.EventNewsProvider;
import com.sap.sailing.news.impl.InfoEventNewsItem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JsonEventNewsProvider
implements EventNewsProvider {
    private static final int UPDATE_INTERVAL = 60000;
    private static final int CONNECTION_TIMEOUT = 15000;
    private static final Logger logger = Logger.getLogger(JsonEventNewsProvider.class.getName());
    private static URL staticNewsURL;
    private List<InfoEventNewsItem> news = new LinkedList<InfoEventNewsItem>();
    private long nextUpdate = 0L;

    static {
        try {
            staticNewsURL = new URL("https://static.sapsailing.com/events_news/news.json");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private synchronized void update() {
        if (this.nextUpdate >= System.currentTimeMillis()) {
            return;
        }
        this.nextUpdate = System.currentTimeMillis() + 60000L;
        try (BufferedReader bufferedReader = null;){
            logger.fine("Updating news from URL " + staticNewsURL);
            URLConnection urlConnection = staticNewsURL.openConnection();
            urlConnection.setConnectTimeout(15000);
            urlConnection.connect();
            bufferedReader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "UTF-8"));
            JSONParser parser = new JSONParser();
            Object newsAsObject = parser.parse((Reader)bufferedReader);
            JSONArray newsAsJsonArray = (JSONArray)newsAsObject;
            LinkedList<InfoEventNewsItem> newNews = new LinkedList<InfoEventNewsItem>();
            for (Object eventAsObject : newsAsJsonArray) {
                JSONObject eventAsJson = (JSONObject)eventAsObject;
                String eventIdAsString = (String)eventAsJson.get((Object)"event");
                Number timestamp = (Number)eventAsJson.get((Object)"timestamp");
                String title = (String)eventAsJson.get((Object)"title");
                Map<Locale, String> titles = this.readI18nText(eventAsJson, "titles");
                String message = (String)eventAsJson.get((Object)"message");
                Map<Locale, String> messages = this.readI18nText(eventAsJson, "messages");
                String newsURL = (String)eventAsJson.get((Object)"url");
                UUID eventId = UUID.fromString(eventIdAsString);
                InfoEventNewsItem newsItem = new InfoEventNewsItem(eventId, title, message, new Date(timestamp.longValue()), newsURL == null ? null : new URL(newsURL), titles, messages);
                newNews.add(newsItem);
            }
            this.news = newNews;
        }
        catch (IOException | ParseException e) {
            logger.log(Level.INFO, "Exception trying to fetch news from " + staticNewsURL, e);
        }
    }

    private Map<Locale, String> readI18nText(JSONObject eventAsJson, String field) {
        Object object = eventAsJson.get((Object)field);
        if (object == null) {
            return Collections.emptyMap();
        }
        JSONObject texts = (JSONObject)object;
        Set entrySet = texts.entrySet();
        HashMap<Locale, String> result = new HashMap<Locale, String>();
        for (Map.Entry entry : entrySet) {
            result.put(Locale.forLanguageTag((String)entry.getKey()), (String)entry.getValue());
        }
        return result;
    }

    @Override
    public Collection<? extends EventNewsItem> getNews(Event event) {
        if (this.nextUpdate < System.currentTimeMillis()) {
            this.update();
        }
        UUID eventId = event.getId();
        LinkedList<InfoEventNewsItem> result = new LinkedList<InfoEventNewsItem>();
        for (InfoEventNewsItem newsEntry : this.news) {
            if (!eventId.equals(newsEntry.getEventUUID())) continue;
            result.add(newsEntry);
        }
        return result;
    }
}

