/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.data;

import com.sap.sailing.datamining.data.HasTrackedRaceContext;
import com.sap.sailing.datamining.data.HasWindTrackContext;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.tracking.WindTrack;

public class WindTrackWithContext
implements HasWindTrackContext {
    private final HasTrackedRaceContext trackedRaceContext;
    private final String windSourceType;
    private final String windSourceName;
    private final WindTrack windTrack;

    public WindTrackWithContext(HasTrackedRaceContext trackedRaceContext, WindTrack windTrack, WindSource windSource) {
        this.trackedRaceContext = trackedRaceContext;
        this.windTrack = windTrack;
        this.windSourceType = windSource.getType().name();
        this.windSourceName = String.valueOf(windSource.getType().name()) + (windSource.getId() == null ? "" : " (" + windSource.getId() + ")");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.windTrack == null ? 0 : this.windTrack.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WindTrackWithContext other = (WindTrackWithContext)obj;
        return !(this.windTrack == null ? other.windTrack != null : !this.windTrack.equals(other.windTrack));
    }

    @Override
    public HasTrackedRaceContext getTrackedRaceContext() {
        return this.trackedRaceContext;
    }

    @Override
    public String getWindSourceType() {
        return this.windSourceType;
    }

    public String toString() {
        return "WindTrackWithContext [trackedRaceContext=" + this.trackedRaceContext + ", windSourceType=" + this.windSourceType + ", windSourceName=" + this.windSourceName + "]";
    }

    @Override
    public String getWindSourceName() {
        return this.windSourceName;
    }

    @Override
    public WindTrack getWindTrack() {
        return this.windTrack;
    }
}

