/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.data;

import com.sap.sailing.datamining.data.HasWindFixContext;
import com.sap.sailing.datamining.data.HasWindTrackContext;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.impl.TimeRangeImpl;

public class WindFixWithContext
implements HasWindFixContext {
    private static final long serialVersionUID = -4537126043228674949L;
    private final HasWindTrackContext windTrackContext;
    private final String windSourceType;
    private final Wind wind;

    public WindFixWithContext(HasWindTrackContext windTrackContext, Wind wind, String windSourceType) {
        this.windTrackContext = windTrackContext;
        this.wind = wind;
        this.windSourceType = windSourceType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.wind == null ? 0 : this.wind.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WindFixWithContext other = (WindFixWithContext)obj;
        return !(this.wind == null ? other.wind != null : !this.wind.equals(other.wind));
    }

    @Override
    public HasWindTrackContext getWindTrackContext() {
        return this.windTrackContext;
    }

    @Override
    public Wind getWind() {
        return this.wind;
    }

    @Override
    public double getWindFromDegrees() {
        return this.getWind().getFrom().getDegrees();
    }

    @Override
    public double getWindSpeedInKnots() {
        return this.getWind().getKnots();
    }

    @Override
    public String getWindSourceType() {
        return this.windSourceType;
    }

    @Override
    public boolean isInTrackingInterval() {
        TrackedRace trackedRace = this.getWindTrackContext().getTrackedRaceContext().getTrackedRace();
        return trackedRace != null && new TimeRangeImpl(trackedRace.getStartOfTracking(), trackedRace.getEndOfTracking()).includes(this.getTimePoint());
    }

    @Override
    public boolean isInRace() {
        TrackedRace trackedRace = this.getWindTrackContext().getTrackedRaceContext().getTrackedRace();
        return trackedRace != null && new TimeRangeImpl(trackedRace.getStartOfRace(), trackedRace.getEndOfRace()).includes(this.getTimePoint());
    }

    public String toString() {
        return "WindFixWithContext [trackedRaceContext=" + this.windTrackContext + ", windSourceType=" + this.windSourceType + ", wind=" + this.wind + "]";
    }
}

