/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.data;

import com.sap.sailing.datamining.data.HasGPSFixTrackContext;
import com.sap.sailing.datamining.data.HasTackTypeSegmentContext;
import com.sap.sailing.datamining.impl.data.GPSFixTrackWithContext;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.TackType;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import java.text.SimpleDateFormat;

public class TackTypeSegmentWithContext
implements HasTackTypeSegmentContext {
    private final HasGPSFixTrackContext gpsFixTrackContext;
    private final TimePoint startOfTackTypeSegment;
    private final TimePoint endOfTackTypeSegment;
    private final TackType tackType;
    private static final SimpleDateFormat TIMEPOINT_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public TackTypeSegmentWithContext(GPSFixTrackWithContext gpsFixTrackWithContext, TimePoint startOfTackTypeSegment, TimePoint endOfTackTypeSegment, TackType tackType) {
        this.gpsFixTrackContext = gpsFixTrackWithContext;
        this.startOfTackTypeSegment = startOfTackTypeSegment;
        this.endOfTackTypeSegment = endOfTackTypeSegment;
        this.tackType = tackType;
    }

    @Override
    public String getName() {
        return String.valueOf(this.gpsFixTrackContext.getRaceOfCompetitorContext().getCompetitor().getName()) + "@" + TIMEPOINT_FORMATTER.format(this.startOfTackTypeSegment.asDate());
    }

    @Override
    public HasGPSFixTrackContext getGPSFixTrackContext() {
        return this.gpsFixTrackContext;
    }

    @Override
    public TimePoint getStartOfTackTypeSegment() {
        return this.startOfTackTypeSegment;
    }

    @Override
    public TimePoint getEndOfTackTypeSegment() {
        return this.endOfTackTypeSegment;
    }

    @Override
    public Duration getDuration() {
        return this.getStartOfTackTypeSegment().until(this.getEndOfTackTypeSegment());
    }

    @Override
    public Distance getDistance() {
        return this.getGpsFixTrack().getDistanceTraveled(this.getStartOfTackTypeSegment(), this.getEndOfTackTypeSegment());
    }

    private GPSFixTrack<Competitor, GPSFixMoving> getGpsFixTrack() {
        return this.getTrackedRace().getTrack(this.getCompetitor());
    }

    private Competitor getCompetitor() {
        return this.getGPSFixTrackContext().getRaceOfCompetitorContext().getCompetitor();
    }

    private TrackedRace getTrackedRace() {
        return this.getGPSFixTrackContext().getRaceOfCompetitorContext().getTrackedRaceContext().getTrackedRace();
    }

    @Override
    public TackType getTackType() {
        return this.tackType;
    }

    @Override
    public LegType getLegType() throws NoWindException {
        return this.getTrackedLeg().getLegType(this.getStartOfTackTypeSegment().plus(this.getStartOfTackTypeSegment().until(this.getEndOfTackTypeSegment()).divide(2L)));
    }

    @Override
    public int getLegNumber() {
        TrackedLeg trackedLeg = this.getTrackedLeg();
        return trackedLeg == null ? 0 : this.getTrackedRace().getRace().getCourse().getIndexOfWaypoint(trackedLeg.getLeg().getTo());
    }

    private TrackedLeg getTrackedLeg() {
        return this.getTrackedRace().getTrackedLeg(this.getCompetitor(), this.getStartOfTackTypeSegment()).getTrackedLeg();
    }

    public String toString() {
        return "TackTypeSegmentWithContext [gpsFixTrackContext=" + this.gpsFixTrackContext + ", startOfTackTypeSegment=" + this.startOfTackTypeSegment + ", endOfTackTypeSegment=" + this.endOfTackTypeSegment + ", tackType=" + this.tackType + "]";
    }
}

