/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.data;

import com.sap.sailing.datamining.data.HasTackTypeSegmentContext;
import com.sap.sailing.domain.common.TackType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public abstract class TackTypeRatioCollector<ADDABLE>
implements Collector<HasTackTypeSegmentContext, Map<TackType, ADDABLE>, Double> {
    private final ADDABLE nullValue;

    public TackTypeRatioCollector(ADDABLE nullValue) {
        this.nullValue = nullValue;
    }

    @Override
    public Supplier<Map<TackType, ADDABLE>> supplier() {
        return () -> {
            HashMap<TackType, ADDABLE> result = new HashMap<TackType, ADDABLE>();
            TackType[] tackTypeArray = TackType.values();
            int n = tackTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TackType tt = tackTypeArray[n2];
                result.put(tt, this.nullValue);
                ++n2;
            }
            return result;
        };
    }

    @Override
    public BiConsumer<Map<TackType, ADDABLE>, HasTackTypeSegmentContext> accumulator() {
        return (sumPerTackType, element) -> {
            TackType tt = element.getTackType();
            TackTypeRatioCollector tackTypeRatioCollector = this;
            synchronized (tackTypeRatioCollector) {
                sumPerTackType.put(tt, this.add(sumPerTackType.get(tt), this.getAddable((HasTackTypeSegmentContext)element)));
            }
        };
    }

    @Override
    public BinaryOperator<Map<TackType, ADDABLE>> combiner() {
        return (r1, r2) -> {
            for (Map.Entry e : r1.entrySet()) {
                r2.put((TackType)e.getKey(), this.add(e.getValue(), r2.get(e.getKey())));
            }
            return r2;
        };
    }

    @Override
    public Function<Map<TackType, ADDABLE>, Double> finisher() {
        return sumPerTackType -> {
            Object shortTackSum = sumPerTackType.get(TackType.SHORTTACK);
            return shortTackSum.equals(this.nullValue) ? null : Double.valueOf(this.divide(sumPerTackType.get(TackType.LONGTACK), shortTackSum));
        };
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }

    protected abstract ADDABLE add(ADDABLE var1, ADDABLE var2);

    protected abstract double divide(ADDABLE var1, ADDABLE var2);

    protected abstract ADDABLE getAddable(HasTackTypeSegmentContext var1);
}

