/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.data;

import com.sap.sailing.datamining.data.HasLeaderboardGroupContext;
import com.sap.sailing.datamining.data.SailorProfile;
import com.sap.sailing.datamining.data.SailorProfiles;
import com.sap.sailing.datamining.impl.data.SailorProfileImpl;
import com.sap.sailing.datamining.impl.data.SailorProfilesImpl;
import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.server.preferences.SailorProfilePreference;
import com.sap.sailing.server.preferences.SailorProfilePreferences;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.impl.User;
import java.util.ArrayList;

public class LeaderboardGroupWithContext
implements HasLeaderboardGroupContext {
    private final LeaderboardGroup leaderboardGroup;
    private final PolarDataService polarDataService;
    private final DomainFactory baseDomainFactory;
    private final SecurityService securityService;
    private SailorProfiles sailorProfiles;

    public LeaderboardGroupWithContext(LeaderboardGroup leaderboardGroup, PolarDataService polarDataService, DomainFactory baseDomainFactory, SecurityService securityService) {
        this.leaderboardGroup = leaderboardGroup;
        this.polarDataService = polarDataService;
        this.baseDomainFactory = baseDomainFactory;
        this.securityService = securityService;
    }

    @Override
    public LeaderboardGroup getLeaderboardGroup() {
        return this.leaderboardGroup;
    }

    @Override
    public PolarDataService getPolarDataService() {
        return this.polarDataService;
    }

    @Override
    public DomainFactory getBaseDomainFactory() {
        return this.baseDomainFactory;
    }

    @Override
    public SecurityService getSecurityService() {
        return this.securityService;
    }

    @Override
    public synchronized SailorProfiles getSailorProfiles() {
        if (this.sailorProfiles == null) {
            User currentUser = this.getSecurityService().getCurrentUser();
            if (currentUser == null) {
                throw new NullPointerException("No user session in DataMining. Thread pool context problems? You may need to attach a user session to the thread.");
            }
            SailorProfilePreferences sailorProfilePreferences = (SailorProfilePreferences)this.getSecurityService().getPreferenceObject(currentUser.getName(), "user.profile.sailorProfiles");
            if (sailorProfilePreferences != null) {
                ArrayList<SailorProfile> theSailorProfiles = new ArrayList<SailorProfile>();
                for (SailorProfilePreference sailorProfilePreference : sailorProfilePreferences.getSailorProfiles()) {
                    SailorProfileImpl sailorProfile = new SailorProfileImpl(sailorProfilePreference.getUuid(), sailorProfilePreference.getName(), sailorProfilePreference.getCompetitors());
                    theSailorProfiles.add(sailorProfile);
                }
                this.sailorProfiles = new SailorProfilesImpl(theSailorProfiles);
            }
        }
        return this.sailorProfiles;
    }
}

