/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.data;

import com.sap.sailing.datamining.Activator;
import com.sap.sailing.datamining.data.HasBravoFixTrackContext;
import com.sap.sailing.datamining.data.HasFoilingSegmentContext;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.common.BearingCluster;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.tracking.BravoFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.tracking.BravoFixTrack;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.datamining.data.Cluster;
import com.sap.sse.datamining.shared.impl.dto.ClusterDTO;
import com.sap.sse.i18n.ResourceBundleStringMessages;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class FoilingSegmentWithContext
implements HasFoilingSegmentContext {
    private final HasBravoFixTrackContext bravoFixTrackContext;
    private final TimePoint startOfFoilingSegment;
    private final TimePoint endOfFoilingSegment;
    private static final SimpleDateFormat TIMEPOINT_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public FoilingSegmentWithContext(HasBravoFixTrackContext bravoFixTrackContext, TimePoint startOfFoilingSegment, TimePoint endOfFoilingSegment) {
        this.bravoFixTrackContext = bravoFixTrackContext;
        this.startOfFoilingSegment = startOfFoilingSegment;
        this.endOfFoilingSegment = endOfFoilingSegment;
    }

    @Override
    public String getName() {
        return String.valueOf(this.bravoFixTrackContext.getRaceOfCompetitorContext().getCompetitor().getName()) + "@" + TIMEPOINT_FORMATTER.format(this.startOfFoilingSegment.asDate());
    }

    @Override
    public HasBravoFixTrackContext getBravoFixTrackContext() {
        return this.bravoFixTrackContext;
    }

    @Override
    public TimePoint getStartOfFoilingSegment() {
        return this.startOfFoilingSegment;
    }

    @Override
    public TimePoint getEndOfFoilingSegment() {
        return this.endOfFoilingSegment;
    }

    @Override
    public Duration getDuration() {
        return this.getStartOfFoilingSegment().until(this.getEndOfFoilingSegment());
    }

    @Override
    public Distance getDistance() {
        return this.getGpsFixTrack().getDistanceTraveled(this.getStartOfFoilingSegment(), this.getEndOfFoilingSegment());
    }

    private GPSFixTrack<Competitor, GPSFixMoving> getGpsFixTrack() {
        return this.getTrackedRace().getTrack(this.getCompetitor());
    }

    private Competitor getCompetitor() {
        return this.getBravoFixTrackContext().getRaceOfCompetitorContext().getCompetitor();
    }

    private TrackedRace getTrackedRace() {
        return this.getBravoFixTrackContext().getRaceOfCompetitorContext().getTrackedRaceContext().getTrackedRace();
    }

    @Override
    public Double getTakeoffSpeedInKnots() {
        SpeedWithBearing estimatedSpeed = this.getGpsFixTrack().getEstimatedSpeed(this.getStartOfFoilingSegment());
        return estimatedSpeed == null ? null : Double.valueOf(estimatedSpeed.getKnots());
    }

    @Override
    public Double getLandingSpeedInKnots() {
        SpeedWithBearing estimatedSpeed = this.getGpsFixTrack().getEstimatedSpeed(this.getEndOfFoilingSegment());
        return estimatedSpeed == null ? null : Double.valueOf(estimatedSpeed.getKnots());
    }

    @Override
    public Bearing getAbsoluteTrueWindAngleAtTakeoffInDegrees() throws NoWindException {
        return this.getAbsoluteTrueWindAngle(this.getStartOfFoilingSegment());
    }

    @Override
    public Bearing getAbsoluteTrueWindAngleAtLandingInDegrees() throws NoWindException {
        TimePoint timePoint = this.getEndOfFoilingSegment();
        return this.getAbsoluteTrueWindAngle(timePoint);
    }

    private Bearing getAbsoluteTrueWindAngle(TimePoint timePoint) throws NoWindException {
        Bearing twa = this.getTrackedRace().getTWA(this.getCompetitor(), timePoint);
        return twa == null ? null : twa.abs();
    }

    @Override
    public Bearing getAverageAbsoluteTrueWindAngle() throws NoWindException {
        BearingCluster bearingCluster = new BearingCluster();
        BravoFixTrack<Competitor> bravoFixTrack = this.getBravoFixTrackContext().getBravoFixTrack();
        bravoFixTrack.lockForRead();
        try {
            for (BravoFix bravoFix : bravoFixTrack.getFixes(this.getStartOfFoilingSegment(), true, this.getEndOfFoilingSegment(), false)) {
                bearingCluster.add(this.getAbsoluteTrueWindAngle(bravoFix.getTimePoint()));
            }
        }
        finally {
            bravoFixTrack.unlockAfterRead();
        }
        return bearingCluster.getAverage();
    }

    @Override
    public ClusterDTO getWindStrengthAsBeaufortClusterAtTakeoff(Locale locale, ResourceBundleStringMessages stringMessages) {
        return this.getWindStrengthAsBeaufortCluster(locale, stringMessages, this.getWindAtTakeoff());
    }

    @Override
    public ClusterDTO getWindStrengthAsBeaufortClusterAtLanding(Locale locale, ResourceBundleStringMessages stringMessages) {
        return this.getWindStrengthAsBeaufortCluster(locale, stringMessages, this.getWindAtLanding());
    }

    private Wind getWind(TimePoint timePoint) {
        return this.getTrackedRace().getWind(this.getGpsFixTrack().getEstimatedPosition(timePoint, true), timePoint);
    }

    @Override
    public Wind getWindAtTakeoff() {
        return this.getWind(this.getStartOfFoilingSegment());
    }

    @Override
    public Wind getWindAtLanding() {
        return this.getWind(this.getEndOfFoilingSegment());
    }

    private ClusterDTO getWindStrengthAsBeaufortCluster(Locale locale, ResourceBundleStringMessages stringMessages, Wind wind) {
        Cluster cluster = Activator.getClusterGroups().getWindStrengthInBeaufortClusterGroup().getClusterFor((Serializable)wind);
        return new ClusterDTO(cluster.toString(), () -> cluster.asLocalizedString(locale, stringMessages));
    }

    @Override
    public LegType getStartsOnLegType() throws NoWindException {
        return this.getLegType(this.getStartOfFoilingSegment());
    }

    private LegType getLegType(TimePoint timePoint) throws NoWindException {
        return this.getTrackedRace().getTrackedLeg(this.getCompetitor(), timePoint).getTrackedLeg().getLegType(timePoint);
    }

    @Override
    public LegType getEndsOnLegType() throws NoWindException {
        return this.getLegType(this.getEndOfFoilingSegment());
    }
}

