/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.data;

import com.sap.sailing.datamining.data.HasBravoFixContext;
import com.sap.sailing.datamining.data.HasTrackedLegOfCompetitorContext;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.tracking.BravoFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindPositionMode;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;

public class BravoFixWithContext
implements HasBravoFixContext {
    private static final long serialVersionUID = 3452314555495774433L;
    private final HasTrackedLegOfCompetitorContext trackedLegOfCompetitorContext;
    private final BravoFix bravoFix;
    private Wind wind;

    public BravoFixWithContext(HasTrackedLegOfCompetitorContext trackedLegOfCompetitorContext, BravoFix bravoFix) {
        this.trackedLegOfCompetitorContext = trackedLegOfCompetitorContext;
        this.bravoFix = bravoFix;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bravoFix == null ? 0 : this.bravoFix.hashCode());
        result = 31 * result + (this.trackedLegOfCompetitorContext == null ? 0 : this.trackedLegOfCompetitorContext.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BravoFixWithContext other = (BravoFixWithContext)obj;
        if (this.bravoFix == null ? other.bravoFix != null : !this.bravoFix.equals(other.bravoFix)) {
            return false;
        }
        return !(this.trackedLegOfCompetitorContext == null ? other.trackedLegOfCompetitorContext != null : !this.trackedLegOfCompetitorContext.equals(other.trackedLegOfCompetitorContext));
    }

    @Override
    public Wind getWindInternal() {
        return this.wind;
    }

    @Override
    public void setWindInternal(Wind wind) {
        this.wind = wind;
    }

    public Position getPosition() {
        return this.getTrackedRace().getTrack(this.getCompetitor()).getEstimatedPosition(this.getTimePoint(), true);
    }

    @Override
    public HasTrackedLegOfCompetitorContext getTrackedLegOfCompetitorContext() {
        return this.trackedLegOfCompetitorContext;
    }

    @Override
    public BravoFix getBravoFix() {
        return this.bravoFix;
    }

    public TimePoint getTimePoint() {
        return this.getBravoFix().getTimePoint();
    }

    @Override
    public TrackedRace getTrackedRace() {
        return this.getTrackedLegOfCompetitorContext().getTrackedRace();
    }

    @Override
    public SpeedWithBearing getSpeed() {
        return this.getGpsFixTrack().getEstimatedSpeed(this.getTimePoint());
    }

    @Override
    public Speed getVelocityMadeGood() {
        return this.getTrackedLegOfCompetitorContext().getTrackedLegOfCompetitor().getVelocityMadeGood(this.getTimePoint(), WindPositionMode.EXACT);
    }

    @Override
    public Wind getWind() {
        return HasBravoFixContext.super.getWind();
    }

    @Override
    public Bearing getTrueWindAngle() {
        return this.getTrackedRace().getTWA(this.getCompetitor(), this.getTimePoint());
    }

    @Override
    public Bearing getAbsoluteTrueWindAngle() {
        return this.getTrackedRace().getTWA(this.getCompetitor(), this.getTimePoint()).abs();
    }

    private Competitor getCompetitor() {
        return this.getTrackedLegOfCompetitorContext().getCompetitor();
    }

    private GPSFixTrack<Competitor, GPSFixMoving> getGpsFixTrack() {
        return this.getTrackedRace().getTrack(this.getTrackedLegOfCompetitorContext().getCompetitor());
    }
}

