/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.data;

import com.sap.sailing.datamining.data.HasBravoFixTrackContext;
import com.sap.sailing.datamining.data.HasRaceOfCompetitorContext;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.tracking.BravoFixTrack;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;

public class BravoFixTrackWithContext
implements HasBravoFixTrackContext {
    private final HasRaceOfCompetitorContext raceOfCompetitorContext;
    private final BravoFixTrack<Competitor> bravoFixTrack;

    public BravoFixTrackWithContext(HasRaceOfCompetitorContext raceOfCompetitorContext, BravoFixTrack<Competitor> bravoFixTrack) {
        this.raceOfCompetitorContext = raceOfCompetitorContext;
        this.bravoFixTrack = bravoFixTrack;
    }

    @Override
    public HasRaceOfCompetitorContext getRaceOfCompetitorContext() {
        return this.raceOfCompetitorContext;
    }

    @Override
    public BravoFixTrack<Competitor> getBravoFixTrack() {
        return this.bravoFixTrack;
    }

    @Override
    public Duration getTimeSpentFoiling() {
        if (this.getRaceOfCompetitorContext().getTrackedRaceContext().getTrackedRace() != null) {
            TimePoint endOfTracking;
            TimePoint endOfRace = this.getRaceOfCompetitorContext().getTrackedRaceContext().getTrackedRace().getEndOfRace();
            TimePoint startOfRace = this.getRaceOfCompetitorContext().getTrackedRaceContext().getTrackedRace().getStartOfRace();
            TimePoint end = endOfRace == null ? ((endOfTracking = this.getRaceOfCompetitorContext().getTrackedRaceContext().getTrackedRace().getEndOfTracking()) == null ? MillisecondsTimePoint.now() : endOfTracking) : endOfRace;
            return this.bravoFixTrack.getTimeSpentFoiling(startOfRace, end);
        }
        return null;
    }

    @Override
    public Distance getDistanceSpentFoiling() {
        if (this.getRaceOfCompetitorContext().getTrackedRaceContext().getTrackedRace() != null) {
            TimePoint endOfTracking;
            TimePoint endOfRace = this.getRaceOfCompetitorContext().getTrackedRaceContext().getTrackedRace().getEndOfRace();
            TimePoint startOfRace = this.getRaceOfCompetitorContext().getTrackedRaceContext().getTrackedRace().getStartOfRace();
            TimePoint end = endOfRace == null ? ((endOfTracking = this.getRaceOfCompetitorContext().getTrackedRaceContext().getTrackedRace().getEndOfTracking()) == null ? MillisecondsTimePoint.now() : endOfTracking) : endOfRace;
            return this.bravoFixTrack.getDistanceSpentFoiling(startOfRace, end);
        }
        return null;
    }
}

