/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.data;

import com.sap.sailing.datamining.Activator;
import com.sap.sailing.datamining.SailingClusterGroups;
import com.sap.sailing.datamining.data.HasTackTypeSegmentContext;
import com.sap.sailing.datamining.data.HasTrackedLegContext;
import com.sap.sailing.datamining.data.HasTrackedLegOfCompetitorContext;
import com.sap.sailing.datamining.impl.components.TackTypeSegmentRetrievalProcessor;
import com.sap.sailing.datamining.impl.data.RaceOfCompetitorWithContext;
import com.sap.sailing.datamining.impl.data.TackTypeRatioCollector;
import com.sap.sailing.datamining.shared.TackTypeSegmentsDataMiningSettings;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.Positioned;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.caching.LeaderboardDTOCalculationReuseCache;
import com.sap.sailing.domain.tracking.BravoFixTrack;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Util;
import com.sap.sse.datamining.data.Cluster;
import com.sap.sse.datamining.shared.impl.dto.ClusterDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class AbstractTrackedLegSliceOfCompetitorWithContext
implements HasTrackedLegOfCompetitorContext,
Positioned {
    private static final long serialVersionUID = 7748860191111327007L;
    private static final long DEFAULT_NUMBER_OF_SLICES = 10L;
    private final HasTrackedLegContext trackedLegContext;
    private final TackTypeSegmentsDataMiningSettings settings;
    private final TrackedLegOfCompetitor trackedLegOfCompetitor;
    private final Competitor competitor;
    private Integer rankAtSliceStart;
    private boolean isRankAtSliceStartInitialized;
    private Integer rankAtSliceFinish;
    private boolean isRankAtSliceFinishInitialized;
    private int sliceNumber;

    public AbstractTrackedLegSliceOfCompetitorWithContext(HasTrackedLegContext trackedLegContext, TrackedLegOfCompetitor trackedLegOfCompetitor, TackTypeSegmentsDataMiningSettings settings, int sliceNumber) {
        this.trackedLegContext = trackedLegContext;
        this.trackedLegOfCompetitor = trackedLegOfCompetitor;
        this.competitor = trackedLegOfCompetitor.getCompetitor();
        this.settings = settings;
        this.sliceNumber = sliceNumber;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.trackedLegOfCompetitor == null ? 0 : this.trackedLegOfCompetitor.hashCode()) ^ this.sliceNumber;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractTrackedLegSliceOfCompetitorWithContext other = (AbstractTrackedLegSliceOfCompetitorWithContext)obj;
        if (this.sliceNumber != other.sliceNumber) {
            return false;
        }
        return !(this.trackedLegOfCompetitor == null ? other.trackedLegOfCompetitor != null : !this.trackedLegOfCompetitor.equals(other.trackedLegOfCompetitor));
    }

    public TimePoint getTimePoint() {
        TrackedLeg trackedLeg = this.getTrackedLegContext().getTrackedLeg();
        TrackedRace trackedRace = trackedLeg.getTrackedRace();
        return this.getTimePointBetweenLegSliceStartAndLegFinish(trackedRace);
    }

    @Override
    public HasTrackedLegContext getTrackedLegContext() {
        return this.trackedLegContext;
    }

    @Override
    public TrackedLegOfCompetitor getTrackedLegOfCompetitor() {
        return this.trackedLegOfCompetitor;
    }

    @Override
    public Competitor getCompetitor() {
        return this.competitor;
    }

    @Override
    public Boat getBoat() {
        Boat boatOfCompetitor = this.getTrackedRace().getBoatOfCompetitor(this.getCompetitor());
        return boatOfCompetitor;
    }

    @Override
    public ClusterDTO getPercentageClusterForRelativeScoreInRace() {
        ClusterDTO result;
        Double relativeScore = this.getTrackedLegContext().getTrackedRaceContext().getRelativeScoreForCompetitor(this.getCompetitor());
        if (relativeScore == null) {
            result = null;
        } else {
            SailingClusterGroups clusterGroups = Activator.getClusterGroups();
            Cluster cluster = clusterGroups.getPercentageClusterGroup().getClusterFor((Serializable)relativeScore);
            result = new ClusterDTO(clusterGroups.getPercentageClusterFormatter().format(cluster));
        }
        return result;
    }

    protected <R> R getSomethingForLegTrackingInterval(BiFunction<TimePoint, TimePoint, R> resultSupplier) {
        TimePoint startTime = this.getSliceStartTime();
        TimePoint finishTime = this.getSliceFinishTime();
        return this.getSomethingForInterval(resultSupplier, startTime, finishTime);
    }

    protected TimePoint getSliceStartTime() {
        return this.getTimePointAtStartOfSlice(this.sliceNumber - 1);
    }

    protected TimePoint getSliceFinishTime() {
        return this.getTimePointAtStartOfSlice(this.sliceNumber);
    }

    private TimePoint getTimePointAtStartOfSlice(int zeroBasedSliceNumber) {
        TimePoint sliceFinishTime;
        TimePoint legStartTime = this.getTrackedLegOfCompetitor().getStartTime();
        if (legStartTime == null) {
            sliceFinishTime = null;
        } else {
            TimePoint finishTime = this.getTrackedLegOfCompetitor().getFinishTime();
            TimePoint effectiveEndOfLeg = this.getEffectiveEndOfLeg(finishTime);
            sliceFinishTime = legStartTime.plus(legStartTime.until(effectiveEndOfLeg).divide(10L).times((long)zeroBasedSliceNumber));
        }
        return sliceFinishTime;
    }

    protected TimePoint getEffectiveEndOfLeg(TimePoint finishTime) {
        return finishTime != null ? finishTime : (this.getTrackedLegContext().getTrackedLeg().getTrackedRace().getEndOfRace() != null ? this.getTrackedLegContext().getTrackedLeg().getTrackedRace().getEndOfRace() : (this.getTrackedLegContext().getTrackedLeg().getTrackedRace().getEndOfTracking() != null ? this.getTrackedLegContext().getTrackedLeg().getTrackedRace().getEndOfTracking() : TimePoint.now()));
    }

    protected <R> R getSomethingForInterval(BiFunction<TimePoint, TimePoint, R> resultSupplier, TimePoint startTime, TimePoint finishTime) {
        R result;
        if (startTime != null) {
            TrackedRace trackedRace = this.getTrackedLegContext().getTrackedLeg().getTrackedRace();
            TimePoint effectiveEndOfInterval = finishTime != null ? finishTime : (trackedRace.getEndOfTracking() != null ? trackedRace.getEndOfTracking() : TimePoint.now());
            result = resultSupplier.apply(startTime, effectiveEndOfInterval);
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public Duration getTimeSpentFoiling() {
        return this.getSomethingForLegTrackingInterval((start, end) -> {
            BravoFixTrack bravoFixTrack = (BravoFixTrack)this.getTrackedLegContext().getTrackedLeg().getTrackedRace().getSensorTrack(this.getCompetitor(), "BravoFixTrack");
            return bravoFixTrack == null ? Duration.NULL : bravoFixTrack.getTimeSpentFoiling(start, end);
        });
    }

    @Override
    public Distance getDistanceSpentFoiling() {
        return this.getSomethingForLegTrackingInterval((start, end) -> {
            BravoFixTrack bravoFixTrack = (BravoFixTrack)this.getTrackedLegContext().getTrackedLeg().getTrackedRace().getSensorTrack(this.getCompetitor(), "BravoFixTrack");
            return bravoFixTrack == null ? Distance.NULL : bravoFixTrack.getDistanceSpentFoiling(start, end);
        });
    }

    @Override
    public Distance getDistanceTraveled() {
        return this.getSomethingForLegTrackingInterval((start, end) -> start == null ? null : this.getTrackedLegOfCompetitor().getDistanceTraveled(end).add(this.getTrackedLegOfCompetitor().getDistanceTraveled(start).scale(-1.0)));
    }

    @Override
    public Double getSpeedAverageInKnots() {
        Duration sliceDuration;
        TrackedLegOfCompetitor trackedLegOfCompetitor;
        Distance distanceTraveledInSlice;
        Speed averageSOG;
        Double result = this.getTrackedRace() == null || this.getSliceStartTime() == null ? null : ((averageSOG = (distanceTraveledInSlice = (trackedLegOfCompetitor = this.getTrackedLegOfCompetitor()).getDistanceTraveled(this.getSliceFinishTime()).add(trackedLegOfCompetitor.getDistanceTraveled(this.getSliceStartTime()).scale(-1.0))).inTime(sliceDuration = this.getSliceStartTime().until(this.getSliceFinishTime()))) == null ? null : Double.valueOf(averageSOG.getKnots()));
        return result;
    }

    @Override
    public Integer getRankGainsOrLosses() {
        Integer rankAtSliceStart = this.getRankAtSliceStart();
        Integer rankAtSliceFinish = this.getRankAtSliceFinish();
        return rankAtSliceStart != null && rankAtSliceFinish != null ? Integer.valueOf(rankAtSliceStart - rankAtSliceFinish) : null;
    }

    private Integer getRankAtSliceStart() {
        Integer result;
        if (this.getTrackedLegContext().getTrackedRaceContext().getTrackedRace() != null) {
            if (!this.isRankAtSliceStartInitialized) {
                int rank = this.getTrackedLegOfCompetitor().getRank(this.getSliceStartTime());
                this.rankAtSliceStart = rank == 0 ? null : Integer.valueOf(rank);
                this.isRankAtSliceStartInitialized = true;
            }
            result = this.rankAtSliceStart;
        } else {
            result = null;
        }
        return result;
    }

    private Integer getRankAtTimePercent(double ratioOfLegSliceTimeSpent) {
        Integer result;
        TrackedRace trackedRace = this.getTrackedLegContext().getTrackedRaceContext().getTrackedRace();
        if (trackedRace != null) {
            TimePoint startTime = this.getSliceStartTime();
            TimePoint finishTime = this.getSliceFinishTime();
            if (startTime != null && finishTime != null) {
                TimePoint timePoint = startTime.plus(startTime.until(finishTime).times(ratioOfLegSliceTimeSpent));
                result = trackedRace.getRank(this.getCompetitor(), timePoint);
            } else {
                result = null;
            }
        } else {
            result = null;
        }
        return result;
    }

    private Integer getRhumbLineBasedRankAtTimePercent(double ratioOfLegTimeSpent) {
        Integer result;
        TrackedRace trackedRace = this.getTrackedLegContext().getTrackedRaceContext().getTrackedRace();
        if (trackedRace != null) {
            TimePoint startTime = this.getSliceStartTime();
            TimePoint finishTime = this.getSliceFinishTime();
            if (startTime != null && finishTime != null) {
                TimePoint timePoint = startTime.plus(startTime.until(finishTime).times(ratioOfLegTimeSpent));
                LeaderboardDTOCalculationReuseCache cache = new LeaderboardDTOCalculationReuseCache(timePoint){

                    public LegType getLegType(TrackedLeg trackedLeg, TimePoint timePoint) throws NoWindException {
                        return LegType.REACHING;
                    }
                };
                trackedRace.getRace().getCourse().lockForRead();
                ArrayList rankedCompetitors = new ArrayList();
                try {
                    Comparator comparator = trackedRace.getRankingMetric().getRaceRankingComparator(timePoint, (WindLegTypeAndLegBearingAndORCPerformanceCurveCache)cache);
                    Util.addAll((Iterable)trackedRace.getRace().getCompetitors(), rankedCompetitors);
                    Collections.sort(rankedCompetitors, comparator);
                }
                finally {
                    trackedRace.getRace().getCourse().unlockAfterRead();
                }
                result = rankedCompetitors.indexOf(this.getCompetitor()) + 1;
            } else {
                result = null;
            }
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public Double getRelativeRank() {
        Leaderboard leaderboard = this.getTrackedLegContext().getTrackedRaceContext().getLeaderboardContext().getLeaderboard();
        double competitorCount = Util.size((Iterable)leaderboard.getCompetitors());
        Integer rankAtSliceFinish = this.getRankAtSliceFinish();
        return rankAtSliceFinish == null ? null : Double.valueOf((double)rankAtSliceFinish.intValue() / competitorCount);
    }

    @Override
    public Integer getRankAtSliceFinish() {
        if (!this.isRankAtSliceFinishInitialized) {
            int rank = this.getTrackedLegOfCompetitor().getRank(this.getSliceFinishTime());
            this.rankAtSliceFinish = rank == 0 ? null : Integer.valueOf(rank);
            this.isRankAtSliceFinishInitialized = true;
        }
        return this.rankAtSliceFinish;
    }

    @Override
    public Long getTimeTakenInSeconds() {
        TimePoint startTime = this.getSliceStartTime();
        TimePoint finishTime = this.getSliceFinishTime();
        Long result = startTime == null || finishTime == null ? null : Long.valueOf((finishTime.asMillis() - startTime.asMillis()) / 1000L);
        return result;
    }

    protected TimePoint getTimePointBetweenLegSliceStartAndLegFinish(TrackedRace trackedRace) {
        TimePoint endTime;
        TimePoint startTime;
        TimePoint competitorLegSliceStartTime = this.getSliceStartTime();
        TimePoint competitorLegSliceEndTime = this.getSliceFinishTime();
        TimePoint timePoint = competitorLegSliceStartTime != null ? competitorLegSliceStartTime : (startTime = trackedRace.getStartOfRace() != null ? trackedRace.getStartOfRace() : trackedRace.getStartOfTracking());
        TimePoint timePoint2 = competitorLegSliceEndTime != null ? competitorLegSliceEndTime : (endTime = trackedRace.getEndOfRace() != null ? trackedRace.getEndOfRace() : trackedRace.getEndOfTracking());
        TimePoint timepoint = endTime == null ? startTime : (startTime == null ? null : startTime.plus(startTime.until(endTime).divide(2L)));
        return timepoint;
    }

    @Override
    public Integer getNumberOfManeuvers() {
        return this.getNumberOfJibes() + this.getNumberOfTacks();
    }

    @Override
    public Integer getNumberOfJibes() {
        return this.getSomethingForLegTrackingInterval((start, end) -> this.getNumberOf(ManeuverType.JIBE, (TimePoint)start, (TimePoint)end));
    }

    @Override
    public Integer getNumberOfTacks() {
        return this.getSomethingForLegTrackingInterval((start, end) -> this.getNumberOf(ManeuverType.TACK, (TimePoint)start, (TimePoint)end));
    }

    private int getNumberOf(ManeuverType maneuverType, TimePoint start, TimePoint end) {
        TrackedRace trackedRace = this.getTrackedRace();
        int number = 0;
        if (trackedRace != null) {
            for (Maneuver maneuver : trackedRace.getManeuvers(this.getCompetitor(), start, end, false)) {
                if (maneuver.getType() != maneuverType) continue;
                ++number;
            }
        }
        return number;
    }

    @Override
    public Integer getRankAfterFirstQuarter() {
        return this.getRankAtTimePercent(0.25);
    }

    @Override
    public Integer getRankAfterSecondQuarter() {
        return this.getRankAtTimePercent(0.5);
    }

    @Override
    public Integer getRankAfterThirdQuarter() {
        return this.getRankAtTimePercent(0.75);
    }

    @Override
    public Double getRankAverageAcrossFirstThreeQuarters() {
        return this.getRankAverageAcrossFirstThreeQuarters(this::getRankAtTimePercent);
    }

    private Double getRankAverageAcrossFirstThreeQuarters(Function<Double, Integer> rankFunction) {
        int rankSum = 0;
        int count = 0;
        double ratio = 0.25;
        while (ratio < 1.0) {
            Integer rankAtRatio = rankFunction.apply(ratio);
            if (rankAtRatio != null) {
                rankSum += rankAtRatio.intValue();
                ++count;
            }
            ratio += 0.25;
        }
        return count == 0 ? null : Double.valueOf((double)rankSum / (double)count);
    }

    @Override
    public Integer getRankRhumbLineBasedAfterFirstQuarter() {
        return this.getRhumbLineBasedRankAtTimePercent(0.25);
    }

    @Override
    public Integer getRankRhumbLineBasedAfterSecondQuarter() {
        return this.getRhumbLineBasedRankAtTimePercent(0.5);
    }

    @Override
    public Integer getRankRhumbLineBasedAfterThirdQuarter() {
        return this.getRhumbLineBasedRankAtTimePercent(0.75);
    }

    @Override
    public Double getRankRhumbLineBasedAverageAcrossFirstThreeQuarters() {
        return this.getRankAverageAcrossFirstThreeQuarters(this::getRhumbLineBasedRankAtTimePercent);
    }

    private Double getRankPredictionError(Supplier<? extends Number> rankPredictor) {
        int numberOfCompetitors;
        Number predictiveRank;
        Integer rankAtFinish = this.getRankAtSliceFinish();
        Double result = rankAtFinish != null ? ((predictiveRank = rankPredictor.get()) != null ? ((numberOfCompetitors = Util.size((Iterable)this.getTrackedRace().getRace().getCompetitors())) != 0 ? Double.valueOf(Math.abs((double)rankAtFinish.intValue() - predictiveRank.doubleValue()) / (double)numberOfCompetitors) : null) : null) : null;
        return result;
    }

    @Override
    public Double getRankPredictionErrorAfterFirstQuarter() {
        return this.getRankPredictionError(this::getRankAfterFirstQuarter);
    }

    @Override
    public Double getRankPredictionErrorAfterSecondQuarter() {
        return this.getRankPredictionError(this::getRankAfterSecondQuarter);
    }

    @Override
    public Double getRankPredictionErrorAfterThirdQuarter() {
        return this.getRankPredictionError(this::getRankAfterThirdQuarter);
    }

    @Override
    public Double getRankPredictionErrorAcrossFirstThreeQuarters() {
        return this.getRankPredictionError(this::getRankAverageAcrossFirstThreeQuarters);
    }

    @Override
    public Double getRankPredictionErrorRhumbLineBasedAfterFirstQuarter() {
        return this.getRankPredictionError(this::getRankRhumbLineBasedAfterFirstQuarter);
    }

    @Override
    public Double getRankPredictionErrorRhumbLineBasedAfterSecondQuarter() {
        return this.getRankPredictionError(this::getRankRhumbLineBasedAfterSecondQuarter);
    }

    @Override
    public Double getRankPredictionErrorRhumbLineBasedAfterThirdQuarter() {
        return this.getRankPredictionError(this::getRankRhumbLineBasedAfterThirdQuarter);
    }

    @Override
    public Double getRankPredictionErrorRhumbLineBasedAcrossFirstThreeQuarters() {
        return this.getRankPredictionError(this::getRankRhumbLineBasedAverageAcrossFirstThreeQuarters);
    }

    @Override
    public Speed getVelocityMadeGood() {
        TimePoint finishTime = this.getSliceFinishTime();
        return this.getTrackedLegOfCompetitor().getAverageVelocityMadeGood(finishTime == null ? TimePoint.now() : finishTime);
    }

    @Override
    public double getRatioDurationLongVsShortTack() {
        TackTypeRatioCollector<Duration> resultProcessor = new TackTypeRatioCollector<Duration>(Duration.NULL){

            @Override
            protected Duration add(Duration a, Duration b) {
                return a.plus(b);
            }

            @Override
            protected double divide(Duration a, Duration b) {
                return a.divide(b);
            }

            @Override
            protected Duration getAddable(HasTackTypeSegmentContext element) {
                return element.getDuration();
            }
        };
        TackTypeSegmentRetrievalProcessor tackTypeSegmentRetriever = new TackTypeSegmentRetrievalProcessor(null, Collections.emptySet(), this.settings, 0, "TackTypeSegments");
        return Util.stream(tackTypeSegmentRetriever.retrieveData(new RaceOfCompetitorWithContext(this.getTrackedLegContext().getTrackedRaceContext(), this.competitor, this.settings))).filter(tt -> tt.getLegNumber() == this.getTrackedLegContext().getLegNumber()).collect(resultProcessor);
    }

    protected boolean isTackTypeSegmentIntersectingWithLegSlice(HasTackTypeSegmentContext tackTypeSegmentContext) {
        return this.getSliceStartTime() != null && tackTypeSegmentContext.getLegNumber() == this.getTrackedLegContext().getLegNumber() && TimeRange.create((TimePoint)tackTypeSegmentContext.getStartOfTackTypeSegment(), (TimePoint)tackTypeSegmentContext.getEndOfTackTypeSegment()).intersects(TimeRange.create((TimePoint)this.getSliceStartTime(), (TimePoint)this.getSliceFinishTime()));
    }

    @Override
    public double getRatioDistanceLongVsShortTack() {
        TackTypeRatioCollector<Distance> resultProcessor = new TackTypeRatioCollector<Distance>((Distance)Distance.NULL){

            @Override
            protected Distance add(Distance a, Distance b) {
                return a.add(b);
            }

            @Override
            protected double divide(Distance a, Distance b) {
                return a.divide(b);
            }

            @Override
            protected Distance getAddable(HasTackTypeSegmentContext element) {
                return element.getDistance();
            }
        };
        TackTypeSegmentRetrievalProcessor tackTypeSegmentRetriever = new TackTypeSegmentRetrievalProcessor(null, Collections.emptySet(), this.settings, 0, "TackTypeSegments");
        return Util.stream(tackTypeSegmentRetriever.retrieveData(new RaceOfCompetitorWithContext(this.getTrackedLegContext().getTrackedRaceContext(), this.competitor, this.settings))).filter(tt -> tt.getLegNumber() == this.getTrackedLegContext().getLegNumber()).collect(resultProcessor);
    }

    public Position getPosition() {
        TrackedLeg trackedLeg = this.getTrackedLegContext().getTrackedLeg();
        TrackedRace trackedRace = trackedLeg.getTrackedRace();
        TimePoint timepoint = this.getTimePointBetweenLegSliceStartAndLegFinish(trackedRace);
        Position result = timepoint == null ? null : trackedLeg.getMiddleOfLeg(timepoint);
        return result;
    }

    protected Integer getTheSliceNumber() {
        return this.sliceNumber;
    }
}

