/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.components.aggregators;

import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sse.common.Distance;
import com.sap.sse.datamining.components.AggregationProcessorDefinition;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.GroupedDataEntry;
import com.sap.sse.datamining.impl.components.SimpleAggregationProcessorDefinition;
import com.sap.sse.datamining.impl.components.aggregators.AbstractParallelGroupedDataStoringAggregationProcessor;
import com.sap.sse.datamining.shared.GroupKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class ParallelDistanceMedianAggregationProcessor
extends AbstractParallelGroupedDataStoringAggregationProcessor<Distance, Distance> {
    private static final AggregationProcessorDefinition<Distance, Distance> DEFINITION = new SimpleAggregationProcessorDefinition(Distance.class, Distance.class, "Median", ParallelDistanceMedianAggregationProcessor.class);
    private Map<GroupKey, List<Distance>> groupedValues = new HashMap<GroupKey, List<Distance>>();

    public static AggregationProcessorDefinition<Distance, Distance> getDefinition() {
        return DEFINITION;
    }

    public ParallelDistanceMedianAggregationProcessor(ExecutorService executor, Collection<Processor<Map<GroupKey, Distance>, ?>> resultReceivers) {
        super(executor, resultReceivers, "Median");
    }

    protected void storeElement(GroupedDataEntry<Distance> element) {
        GroupKey key = element.getKey();
        if (!this.groupedValues.containsKey(key)) {
            this.groupedValues.put(key, new ArrayList());
        }
        this.groupedValues.get(key).add((Distance)element.getDataEntry());
    }

    protected Map<GroupKey, Distance> aggregateResult() {
        HashMap<GroupKey, Distance> result = new HashMap<GroupKey, Distance>();
        for (Map.Entry<GroupKey, List<Distance>> groupedValuesEntry : this.groupedValues.entrySet()) {
            if (this.isAborted()) break;
            result.put(groupedValuesEntry.getKey(), this.getMedianOf(groupedValuesEntry.getValue()));
        }
        return result;
    }

    private Distance getMedianOf(List<Distance> values) {
        Collections.sort(values);
        if (this.listSizeIsEven(values)) {
            int index1 = values.size() / 2 - 1;
            int index2 = index1 + 1;
            return new MeterDistance((values.get(index1).getMeters() + values.get(index2).getMeters()) / 2.0);
        }
        int index = (values.size() + 1) / 2 - 1;
        return values.get(index);
    }

    private boolean listSizeIsEven(List<?> values) {
        return values.size() % 2 == 0;
    }
}

