/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.components.aggregators;

import com.sap.sse.datamining.components.AggregationProcessorDefinition;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.GroupedDataEntry;
import com.sap.sse.datamining.impl.components.SimpleAggregationProcessorDefinition;
import com.sap.sse.datamining.impl.components.aggregators.AbstractParallelGroupedDataAggregationProcessor;
import com.sap.sse.datamining.shared.GroupKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class ParallelBoolSumAggregationProcessor
extends AbstractParallelGroupedDataAggregationProcessor<Boolean, Double> {
    private static final AggregationProcessorDefinition<Boolean, Double> DEFINITION = new SimpleAggregationProcessorDefinition(Boolean.class, Double.class, "Sum", ParallelBoolSumAggregationProcessor.class);
    private Map<GroupKey, Double> result = new HashMap<GroupKey, Double>();

    public static AggregationProcessorDefinition<Boolean, Double> getDefinition() {
        return DEFINITION;
    }

    public ParallelBoolSumAggregationProcessor(ExecutorService executor, Collection<Processor<Map<GroupKey, Double>, ?>> resultReceivers) {
        super(executor, resultReceivers, "Sum");
    }

    protected void handleElement(GroupedDataEntry<Boolean> element) {
        GroupKey key = element.getKey();
        if (!this.result.containsKey(key)) {
            this.result.put(key, 0.0);
        }
        Double currentAmount = this.result.get(key);
        if (((Boolean)element.getDataEntry()).booleanValue()) {
            this.result.put(key, currentAmount + 1.0);
        }
    }

    protected Map<GroupKey, Double> getResult() {
        return this.result;
    }
}

