/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.components.aggregators;

import com.sap.sailing.datamining.data.ManeuverSpeedDetailsStatistic;
import com.sap.sailing.datamining.impl.components.ManeuverSpeedDetailsUtils;
import com.sap.sailing.datamining.impl.data.ManeuverSpeedDetailsStatisticImpl;
import com.sap.sailing.datamining.shared.ManeuverSpeedDetailsAggregation;
import com.sap.sailing.datamining.shared.ManeuverSpeedDetailsAggregationImpl;
import com.sap.sailing.datamining.shared.ManeuverSpeedDetailsSettings;
import com.sap.sse.datamining.impl.components.GroupedDataEntry;
import com.sap.sse.datamining.shared.GroupKey;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class ManeuverSpeedDetailsStatisticAggregationProcessorHelper {
    private final Map<GroupKey, ManeuverSpeedDetailsAggregationCreatorHelper> resultMap = new HashMap<GroupKey, ManeuverSpeedDetailsAggregationCreatorHelper>();
    private Class<?> aggregationCreatorClass;

    public ManeuverSpeedDetailsStatisticAggregationProcessorHelper(Class<?> aggregationCreatorClass) {
        this.aggregationCreatorClass = aggregationCreatorClass;
    }

    protected void storeElement(GroupedDataEntry<ManeuverSpeedDetailsStatistic> element) {
        ManeuverSpeedDetailsAggregationCreatorHelper speedDetailsAggregationHelper;
        ManeuverSpeedDetailsStatistic statistic = (ManeuverSpeedDetailsStatistic)element.getDataEntry();
        ManeuverSpeedDetailsSettings settings = statistic.getSettings();
        if (settings.isNormalizeManeuverDirection() && statistic.getManeuverDirection() != settings.getNormalizedManeuverDirection()) {
            double[] newValuesPerTWA = ManeuverSpeedDetailsUtils.flipManeuversDirection(statistic.getManeuverValuePerTWA());
            statistic = new ManeuverSpeedDetailsStatisticImpl(newValuesPerTWA, statistic.getManeuverDirection(), statistic.getSettings());
        }
        if ((speedDetailsAggregationHelper = this.resultMap.get(element.getKey())) == null) {
            speedDetailsAggregationHelper = new ManeuverSpeedDetailsAggregationCreatorHelper();
            this.resultMap.put(element.getKey(), speedDetailsAggregationHelper);
        }
        speedDetailsAggregationHelper.addElement(statistic);
    }

    protected Map<GroupKey, ManeuverSpeedDetailsAggregation> aggregateResult() {
        HashMap<GroupKey, ManeuverSpeedDetailsAggregation> convertedResultMap = new HashMap<GroupKey, ManeuverSpeedDetailsAggregation>();
        for (Map.Entry<GroupKey, ManeuverSpeedDetailsAggregationCreatorHelper> entry : this.resultMap.entrySet()) {
            ManeuverSpeedDetailsAggregation aggregation = entry.getValue().aggregateResult();
            if (aggregation == null) continue;
            convertedResultMap.put(entry.getKey(), aggregation);
        }
        return convertedResultMap;
    }

    static interface ManeuverSpeedDetailsAggregationCreator {
        public void addElement(ManeuverSpeedDetailsStatistic var1);

        public ManeuverSpeedDetailsAggregation aggregateResult();
    }

    private class ManeuverSpeedDetailsAggregationCreatorHelper
    implements ManeuverSpeedDetailsAggregationCreator {
        private ManeuverSpeedDetailsAggregationCreator allManeuvers = null;
        private ManeuverSpeedDetailsAggregationCreator portsideManeuvers = null;
        private ManeuverSpeedDetailsAggregationCreator starboardManeuvers = null;

        private ManeuverSpeedDetailsAggregationCreatorHelper() {
        }

        @Override
        public void addElement(ManeuverSpeedDetailsStatistic statistic) {
            if (statistic.getSettings().isManeuverDirectionEqualWeightingEnabled()) {
                switch (statistic.getManeuverDirection()) {
                    case PORT: {
                        if (this.portsideManeuvers == null) {
                            try {
                                this.portsideManeuvers = (ManeuverSpeedDetailsAggregationCreator)ManeuverSpeedDetailsStatisticAggregationProcessorHelper.this.aggregationCreatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            }
                            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                                // empty catch block
                            }
                        }
                        this.portsideManeuvers.addElement(statistic);
                    }
                    case STARBOARD: {
                        if (this.starboardManeuvers == null) {
                            try {
                                this.starboardManeuvers = (ManeuverSpeedDetailsAggregationCreator)ManeuverSpeedDetailsStatisticAggregationProcessorHelper.this.aggregationCreatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            }
                            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                                // empty catch block
                            }
                        }
                        this.starboardManeuvers.addElement(statistic);
                    }
                }
            } else {
                if (this.allManeuvers == null) {
                    try {
                        this.allManeuvers = (ManeuverSpeedDetailsAggregationCreator)ManeuverSpeedDetailsStatisticAggregationProcessorHelper.this.aggregationCreatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                        // empty catch block
                    }
                }
                this.allManeuvers.addElement(statistic);
            }
        }

        @Override
        public ManeuverSpeedDetailsAggregation aggregateResult() {
            if (this.allManeuvers != null) {
                return this.allManeuvers.aggregateResult();
            }
            if (this.starboardManeuvers == null) {
                return this.portsideManeuvers != null ? this.portsideManeuvers.aggregateResult() : null;
            }
            if (this.portsideManeuvers == null) {
                return this.starboardManeuvers != null ? this.starboardManeuvers.aggregateResult() : null;
            }
            ManeuverSpeedDetailsAggregation starboardResult = this.starboardManeuvers.aggregateResult();
            ManeuverSpeedDetailsAggregation portsideResult = this.portsideManeuvers.aggregateResult();
            int count = starboardResult.getCount() + portsideResult.getCount();
            int[] countPerTWA = new int[360];
            double[] valuePerTWA = new double[360];
            int[] starboardCountPerTWA = starboardResult.getCountPerTWA();
            int[] portsideCountPerTWA = portsideResult.getCountPerTWA();
            double[] starboardValuePerTWA = starboardResult.getValuePerTWA();
            double[] portsideValuePerTWA = portsideResult.getValuePerTWA();
            int i = 0;
            while (i < 360) {
                countPerTWA[i] = starboardCountPerTWA[i] + portsideCountPerTWA[i];
                double divisor = starboardValuePerTWA[i] == 0.0 || portsideValuePerTWA[i] == 0.0 ? 1 : 2;
                valuePerTWA[i] = (starboardValuePerTWA[i] + portsideValuePerTWA[i]) / divisor;
                ++i;
            }
            return new ManeuverSpeedDetailsAggregationImpl(valuePerTWA, countPerTWA, count);
        }
    }
}

