/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.components;

import com.sap.sailing.datamining.data.HasLeaderboardContext;
import com.sap.sailing.datamining.data.HasTrackedRaceContext;
import com.sap.sailing.datamining.impl.data.TrackedRaceWithContext;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.AbstractRetrievalProcessor;
import com.sap.sse.security.shared.HasPermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public class TrackedRaceRetrievalProcessor
extends AbstractRetrievalProcessor<HasLeaderboardContext, HasTrackedRaceContext> {
    public TrackedRaceRetrievalProcessor(ExecutorService executor, Collection<Processor<HasTrackedRaceContext, ?>> resultReceivers, int retrievalLevel, String retrievedDataTypeMessageKey) {
        super(HasLeaderboardContext.class, HasTrackedRaceContext.class, executor, resultReceivers, retrievalLevel, retrievedDataTypeMessageKey);
    }

    protected Iterable<HasTrackedRaceContext> retrieveData(HasLeaderboardContext element) {
        ArrayList<HasTrackedRaceContext> trackedRacesWithContext = new ArrayList<HasTrackedRaceContext>();
        block0: for (RaceColumn raceColumn : element.getLeaderboard().getRaceColumns()) {
            if (this.isAborted()) break;
            for (Fleet fleet : raceColumn.getFleets()) {
                if (this.isAborted()) continue block0;
                TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
                Subject subject = SecurityUtils.getSubject();
                if (trackedRace != null && subject.isPermitted(trackedRace.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ))) {
                    Regatta regatta = trackedRace.getTrackedRegatta().getRegatta();
                    if (!subject.isPermitted(regatta.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ))) continue;
                    TrackedRaceWithContext trackedRaceWithContext = new TrackedRaceWithContext(element, regatta, raceColumn, fleet, trackedRace);
                    trackedRacesWithContext.add(trackedRaceWithContext);
                    continue;
                }
                TrackedRaceWithContext trackedRaceWithContext = new TrackedRaceWithContext(element, null, raceColumn, fleet, null);
                trackedRacesWithContext.add(trackedRaceWithContext);
            }
        }
        return trackedRacesWithContext;
    }
}

