/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.components;

import com.sap.sailing.datamining.data.HasLeaderboardGroupContext;
import com.sap.sailing.datamining.impl.data.LeaderboardGroupWithContext;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.AbstractRetrievalProcessor;
import com.sap.sse.security.shared.HasPermissions;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public class LeaderboardGroupRetrievalProcessor
extends AbstractRetrievalProcessor<RacingEventService, HasLeaderboardGroupContext> {
    public LeaderboardGroupRetrievalProcessor(ExecutorService executor, Collection<Processor<HasLeaderboardGroupContext, ?>> resultReceivers, int retrievalLevel, String retrievedDataTypeMessageKey) {
        super(RacingEventService.class, HasLeaderboardGroupContext.class, executor, resultReceivers, retrievalLevel, retrievedDataTypeMessageKey);
    }

    protected Iterable<HasLeaderboardGroupContext> retrieveData(RacingEventService element) {
        HashSet<HasLeaderboardGroupContext> data = new HashSet<HasLeaderboardGroupContext>();
        PolarDataService polarDataService = element.getPolarDataService();
        for (LeaderboardGroup leaderboardGroup : element.getLeaderboardGroups().values()) {
            if (this.isAborted()) break;
            Subject subject = SecurityUtils.getSubject();
            if (!subject.isPermitted(leaderboardGroup.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ))) continue;
            data.add(new LeaderboardGroupWithContext(leaderboardGroup, polarDataService, element.getBaseDomainFactory(), element.getSecurityService()));
        }
        return data;
    }
}

