/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.components;

import com.sap.sailing.datamining.data.HasBravoFixContext;
import com.sap.sailing.datamining.data.HasTrackedLegOfCompetitorContext;
import com.sap.sailing.datamining.impl.data.BravoFixWithContext;
import com.sap.sailing.domain.common.tracking.BravoFix;
import com.sap.sailing.domain.tracking.BravoFixTrack;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.AbstractRetrievalProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;

public class BravoFixRetrievalProcessor
extends AbstractRetrievalProcessor<HasTrackedLegOfCompetitorContext, HasBravoFixContext> {
    public BravoFixRetrievalProcessor(ExecutorService executor, Collection<Processor<HasBravoFixContext, ?>> resultReceivers, int retrievalLevel, String retrievedDataTypeMessageKey) {
        super(HasTrackedLegOfCompetitorContext.class, HasBravoFixContext.class, executor, resultReceivers, retrievalLevel, retrievedDataTypeMessageKey);
    }

    protected Iterable<HasBravoFixContext> retrieveData(HasTrackedLegOfCompetitorContext element) {
        BravoFixTrack bravoFixTrack;
        ArrayList<HasBravoFixContext> bravoFixesWithContext = new ArrayList<HasBravoFixContext>();
        TrackedLegOfCompetitor trackedLegOfCompetitor = element.getTrackedLegOfCompetitor();
        if (trackedLegOfCompetitor.getStartTime() != null && trackedLegOfCompetitor.getFinishTime() != null && (bravoFixTrack = (BravoFixTrack)element.getTrackedLegContext().getTrackedRaceContext().getTrackedRace().getSensorTrack(element.getCompetitor(), "BravoFixTrack")) != null) {
            bravoFixTrack.lockForRead();
            try {
                for (BravoFix bravoFix : bravoFixTrack.getFixes(trackedLegOfCompetitor.getStartTime(), true, trackedLegOfCompetitor.getFinishTime(), true)) {
                    if (this.isAborted()) {
                        break;
                    }
                    BravoFixWithContext gpsFixWithContext = new BravoFixWithContext(element, bravoFix);
                    bravoFixesWithContext.add(gpsFixWithContext);
                }
            }
            finally {
                bravoFixTrack.unlockAfterRead();
            }
        }
        return bravoFixesWithContext;
    }
}

