/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.queclinkadapter.tracker;

import com.sap.sailing.domain.queclinkadapter.ByteStreamToMessageStreamConverter;
import com.sap.sailing.domain.queclinkadapter.Message;
import com.sap.sailing.domain.queclinkadapter.tracker.MessageToDeviceSender;
import com.sap.sailing.domain.queclinkadapter.tracker.MessageVisitorWithSensorFixStore;
import com.sap.sailing.domain.racelog.tracking.SensorFixStore;
import com.sap.sailing.domain.racelogtracking.SmartphoneImeiIdentifier;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class QueclinkTCPTracker
implements MessageToDeviceSender {
    private static final Logger logger = Logger.getLogger(QueclinkTCPTracker.class.getName());
    private final AsynchronousServerSocketChannel serverSocketChannel;
    private final ConcurrentMap<String, AsynchronousSocketChannel> socketChannelsByImei;
    private final SensorFixStore sensorFixStore;
    private final Charset charset;
    private volatile boolean stopped;

    public QueclinkTCPTracker(int port, SensorFixStore sensorFixStore) throws IOException {
        this(port, Charset.forName("ISO-8859-1"), sensorFixStore);
    }

    public QueclinkTCPTracker(int port, Charset charset, SensorFixStore sensorFixStore) throws IOException {
        this.sensorFixStore = sensorFixStore;
        this.charset = charset;
        this.socketChannelsByImei = new ConcurrentHashMap<String, AsynchronousSocketChannel>();
        this.serverSocketChannel = AsynchronousServerSocketChannel.open();
        this.serverSocketChannel.bind(new InetSocketAddress(port));
        this.handleAccept(this.getPort());
    }

    public int getPort() throws IOException {
        return ((InetSocketAddress)this.serverSocketChannel.getLocalAddress()).getPort();
    }

    @Override
    public void sendToDevice(SmartphoneImeiIdentifier deviceIdentifier, Message message) {
        String imei = deviceIdentifier.getImei();
        AsynchronousSocketChannel channel = (AsynchronousSocketChannel)this.socketChannelsByImei.get(imei);
        if (channel == null) {
            throw new IllegalStateException("No connection exists to the device with IMEI " + imei + "; cannot send message " + message.getMessageString());
        }
        channel.write(this.charset.encode(CharBuffer.wrap(message.getMessageString())));
    }

    private void handleConnection(final AsynchronousSocketChannel socketChannel, int port) {
        logger.info(() -> {
            try {
                return "Received connection on port " + this.getPort() + " from remote address " + socketChannel.getRemoteAddress();
            }
            catch (IOException e) {
                return "Exception trying to compute log message: " + e.getMessage();
            }
        });
        final MessageVisitorWithSensorFixStore<AsynchronousSocketChannel> storeFixVisitor = new MessageVisitorWithSensorFixStore<AsynchronousSocketChannel>(this.sensorFixStore, this, this.socketChannelsByImei, socketChannel);
        final ByteBuffer buf = ByteBuffer.allocateDirect(8192);
        final ByteStreamToMessageStreamConverter converter = ByteStreamToMessageStreamConverter.create();
        CompletionHandler<Integer, Integer> connectionHandler = new CompletionHandler<Integer, Integer>(){

            @Override
            public void completed(Integer result, Integer port) {
                if (result != -1) {
                    buf.flip();
                    try {
                        converter.convert(QueclinkTCPTracker.this.charset.decode(buf)).forEach(message -> {
                            logger.fine(() -> "Processing message " + message);
                            message.accept(storeFixVisitor);
                        });
                    }
                    catch (ParseException e) {
                        logger.log(Level.SEVERE, "Error trying to convert messages receive through TCP on port " + port, e);
                    }
                    buf.clear();
                    socketChannel.read(buf, null, this);
                } else {
                    try {
                        socketChannel.close();
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "Error trying to close TCP connection on port " + port, e);
                    }
                }
            }

            @Override
            public void failed(Throwable exc, Integer port) {
                logger.log(Level.SEVERE, "Error trying to read from TCP connection on port " + port, exc);
            }
        };
        socketChannel.read(buf, port, connectionHandler);
    }

    private void handleAccept(int port) {
        this.serverSocketChannel.accept(port, new CompletionHandler<AsynchronousSocketChannel, Integer>(){

            @Override
            public void completed(AsynchronousSocketChannel result, Integer port) {
                QueclinkTCPTracker.this.handleAccept(port);
                QueclinkTCPTracker.this.handleConnection(result, port);
            }

            @Override
            public void failed(Throwable exc, Integer port) {
                if (!QueclinkTCPTracker.this.stopped) {
                    logger.log(Level.SEVERE, "Error trying to accept TCP connection on port " + port, exc);
                }
            }
        });
    }

    public void stop() throws IOException {
        this.stopped = true;
        for (AsynchronousSocketChannel socketChannel : this.socketChannelsByImei.values()) {
            try {
                socketChannel.close();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error trying to close socket channel; continuing with other channels if any", e);
            }
        }
        this.serverSocketChannel.close();
    }
}

