/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.queclinkadapter.impl;

import com.sap.sailing.domain.base.impl.KilometersPerHourSpeedWithBearingImpl;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.domain.queclinkadapter.FRIReport;
import com.sap.sailing.domain.queclinkadapter.IOStatus;
import com.sap.sailing.domain.queclinkadapter.MessageType;
import com.sap.sailing.domain.queclinkadapter.MessageVisitor;
import com.sap.sailing.domain.queclinkadapter.PositionRelatedReport;
import com.sap.sailing.domain.queclinkadapter.impl.MessageParserImpl;
import com.sap.sailing.domain.queclinkadapter.impl.MessageWithDeviceOriginImpl;
import com.sap.sailing.domain.queclinkadapter.impl.PositionRelatedReportImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import java.text.ParseException;
import java.util.ArrayList;

public class FRIReportImpl
extends MessageWithDeviceOriginImpl
implements FRIReport {
    private final Byte reportId;
    private final Byte reportType;
    private final Byte batteryPercentage;
    private final IOStatus ioStatus;
    private final PositionRelatedReport[] positionRelatedReports;

    public FRIReportImpl(int protocolVersion, String imei, String deviceName, Byte reportId, Byte reportType, PositionRelatedReport[] positionRelatedReports, Byte batteryPercentage, IOStatus ioStatus, TimePoint sendTime, short countNumber) {
        super(MessageType.FRI, MessageType.Direction.RESP, protocolVersion, imei, deviceName, sendTime, countNumber);
        this.reportId = reportId;
        this.reportType = reportType;
        this.batteryPercentage = batteryPercentage;
        this.ioStatus = ioStatus;
        this.positionRelatedReports = positionRelatedReports;
    }

    public static FRIReportImpl createFromParameters(String[] parameterList) throws ParseException {
        int countNumberIndex;
        int sendTimeIndex;
        IOStatus ioStatus;
        int numberOfFixes = Byte.parseByte(parameterList[5]);
        int FIELDS_PER_FIX = 12;
        if (parameterList.length > 9 + numberOfFixes * 12) {
            ioStatus = new IOStatus(parameterList[7 + numberOfFixes * 12]);
            sendTimeIndex = 8 + numberOfFixes * 12;
            countNumberIndex = 9 + numberOfFixes * 12;
        } else {
            sendTimeIndex = 7 + numberOfFixes * 12;
            countNumberIndex = 8 + numberOfFixes * 12;
            ioStatus = null;
        }
        ArrayList<PositionRelatedReportImpl> positionRelatedReports = new ArrayList<PositionRelatedReportImpl>();
        int i = 0;
        while (i < numberOfFixes) {
            PositionRelatedReportImpl positionRelatedReport = new PositionRelatedReportImpl(Util.hasLength((String)parameterList[6 + i * 12]) ? Byte.valueOf(Byte.parseByte(parameterList[6 + i * 12])) : null, (SpeedWithBearing)(Util.hasLength((String)parameterList[7 + i * 12]) && Util.hasLength((String)parameterList[8 + i * 12]) ? new KilometersPerHourSpeedWithBearingImpl(Double.parseDouble(parameterList[7 + i * 12]), (Bearing)new DegreeBearingImpl(Double.parseDouble(parameterList[8 + i * 12]))) : null), (Distance)(Util.hasLength((String)parameterList[9 + i * 12]) ? new MeterDistance(Double.parseDouble(parameterList[9 + i * 12])) : null), (Position)(Util.hasLength((String)parameterList[11 + i * 12]) && Util.hasLength((String)parameterList[10 + i * 12]) ? new DegreePosition(Double.parseDouble(parameterList[11 + i * 12]), Double.parseDouble(parameterList[10 + i * 12])) : null), MessageParserImpl.parseTimeStamp(parameterList[12 + i * 12]), Util.hasLength((String)parameterList[13 + i * 12]) ? Short.valueOf(Short.parseShort(parameterList[13 + i * 12])) : null, Util.hasLength((String)parameterList[14 + i * 12]) ? Short.valueOf(Short.parseShort(parameterList[14 + i * 12])) : null, Util.hasLength((String)parameterList[15 + i * 12]) ? Integer.valueOf(Integer.parseInt(parameterList[15 + i * 12], 16)) : null, Util.hasLength((String)parameterList[16 + i * 12]) ? Integer.valueOf(Integer.parseInt(parameterList[16 + i * 12], 16)) : null, (Distance)(Util.hasLength((String)parameterList[17 + i * 12]) ? new MeterDistance(1000.0 * Double.parseDouble(parameterList[17 + i * 12])) : null));
            if (positionRelatedReport.getPosition() != null && positionRelatedReport.getValidityTime() != null) {
                positionRelatedReports.add(positionRelatedReport);
            }
            ++i;
        }
        return new FRIReportImpl(MessageParserImpl.parseProtocolVersionHex(parameterList[0]), parameterList[1], parameterList[2], Util.hasLength((String)parameterList[3]) ? Byte.valueOf(Byte.parseByte(parameterList[3])) : null, Util.hasLength((String)parameterList[4]) ? Byte.valueOf(Byte.parseByte(parameterList[4])) : null, positionRelatedReports.toArray(new PositionRelatedReport[positionRelatedReports.size()]), Util.hasLength((String)parameterList[6 + numberOfFixes * 12]) ? Byte.valueOf(Byte.parseByte(parameterList[6 + numberOfFixes * 12])) : null, ioStatus, MessageParserImpl.parseTimeStamp(parameterList[sendTimeIndex]), MessageParserImpl.parseCountNumberHex(parameterList[countNumberIndex]));
    }

    @Override
    public String[] getParameters() {
        return new String[]{MessageParserImpl.formatProtocolVersionHex(this.getProtocolVersion()), this.getImei(), this.getDeviceName(), this.getSendTime() == null ? "" : MessageParserImpl.formatAsYYYYMMDDHHMMSS(this.getSendTime()), MessageParserImpl.formatCountNumberHex(this.getCountNumber())};
    }

    @Override
    public Byte getReportId() {
        return this.reportId;
    }

    @Override
    public Byte getReportType() {
        return this.reportType;
    }

    @Override
    public byte getNumberOfFixes() {
        return (byte)this.positionRelatedReports.length;
    }

    @Override
    public PositionRelatedReport[] getPositionRelatedReports() {
        return this.positionRelatedReports;
    }

    @Override
    public Byte getBatteryPercentage() {
        return this.batteryPercentage;
    }

    @Override
    public IOStatus getIoStatus() {
        return this.ioStatus;
    }

    @Override
    public <T> T accept(MessageVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

