/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.grib.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.MeterPerSecondSpeedWithDegreeBearingImpl;
import com.sap.sailing.domain.common.impl.RadianBearingImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sailing.domain.tracking.impl.WindWithConfidenceImpl;
import com.sap.sailing.grib.impl.AbstractGribWindFieldImpl;
import com.sap.sailing.grib.impl.CompositeVariableSpecification;
import com.sap.sailing.grib.impl.Grib1VariableSpecification;
import com.sap.sailing.grib.impl.Grib2VariableSpecification;
import com.sap.sailing.grib.impl.VariableSpecification;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import ucar.ma2.Array;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.FeatureDataset;

public class UVWindField
extends AbstractGribWindFieldImpl {
    private static final Logger logger = Logger.getLogger(UVWindField.class.getName());
    private static final int U_COMPONENT_OF_WIND_PARAMETER_ID = 33;
    private static final int U_COMPONENT_OF_WIND_GRIB2_DISCIPLINE = 0;
    private static final int U_COMPONENT_OF_WIND_GRIB2_PARAMETER_CATEGORY = 2;
    private static final int U_COMPONENT_OF_WIND_GRIB2_PARAMETER_NUMBER = 2;
    private static final int V_COMPONENT_OF_WIND_PARAMETER_ID = 34;
    private static final int V_COMPONENT_OF_WIND_GRIB2_DISCIPLINE = 0;
    private static final int V_COMPONENT_OF_WIND_GRIB2_PARAMETER_CATEGORY = 2;
    private static final int V_COMPONENT_OF_WIND_GRIB2_PARAMETER_NUMBER = 3;
    private static final VariableSpecification uComponentOfWindVariableSpecification;
    private static final VariableSpecification vComponentOfWindVariableSpecification;

    static {
        VariableSpecification[] variableSpecificationArray = new VariableSpecification[2];
        variableSpecificationArray[0] = new Grib1VariableSpecification(33);
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArray[2] = 2;
        variableSpecificationArray[1] = new Grib2VariableSpecification(nArray);
        uComponentOfWindVariableSpecification = new CompositeVariableSpecification(variableSpecificationArray);
        VariableSpecification[] variableSpecificationArray2 = new VariableSpecification[2];
        variableSpecificationArray2[0] = new Grib1VariableSpecification(34);
        int[] nArray2 = new int[3];
        nArray2[1] = 2;
        nArray2[2] = 3;
        variableSpecificationArray2[1] = new Grib2VariableSpecification(nArray2);
        vComponentOfWindVariableSpecification = new CompositeVariableSpecification(variableSpecificationArray2);
    }

    public UVWindField(FeatureDataset ... dataSets) {
        super(0.5, dataSets);
    }

    @Override
    public WindWithConfidence<TimePoint> getWind(TimePoint timePoint, Position position) throws IOException {
        Wind wind;
        double confidence;
        Util.Triple<Double, TimePoint, Position> uComponentInMetersPerSecond = null;
        Util.Triple<Double, TimePoint, Position> vComponentInMetersPerSecond = null;
        FeatureDataset[] featureDatasetArray = this.getDataSets();
        int n = featureDatasetArray.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureDataset dataSet = featureDatasetArray[n2];
            if (dataSet instanceof GridDataset) {
                for (GridDatatype grid : ((GridDataset)dataSet).getGrids()) {
                    if (uComponentOfWindVariableSpecification.matches((VariableSimpleIF)grid.getVariable())) {
                        assert (this.isMetersPerSecond(this.getUnit(grid.getVariable()).get()));
                        uComponentInMetersPerSecond = this.getValue(grid, timePoint, position);
                    } else if (vComponentOfWindVariableSpecification.matches((VariableSimpleIF)grid.getVariable())) {
                        assert (this.isMetersPerSecond(this.getUnit(grid.getVariable()).get()));
                        vComponentInMetersPerSecond = this.getValue(grid, timePoint, position);
                    }
                    if (uComponentInMetersPerSecond != null && vComponentInMetersPerSecond != null) break;
                }
            }
            ++n2;
        }
        if (uComponentInMetersPerSecond != null && vComponentInMetersPerSecond != null) {
            confidence = this.getTimeConfidence(timePoint, (TimePoint)uComponentInMetersPerSecond.getB());
            wind = this.createWindFixFromUAndV((Position)uComponentInMetersPerSecond.getC(), (TimePoint)uComponentInMetersPerSecond.getB(), (Double)uComponentInMetersPerSecond.getA(), (Double)vComponentInMetersPerSecond.getA());
        } else {
            wind = null;
            confidence = 0.0;
        }
        return new WindWithConfidenceImpl(wind, confidence * this.getBaseConfidence(), (Object)timePoint, true);
    }

    public static boolean handles(FeatureDataset ... dataSets) {
        return UVWindField.hasVariable(uComponentOfWindVariableSpecification, dataSets) && UVWindField.hasVariable(vComponentOfWindVariableSpecification, dataSets);
    }

    @Override
    public Iterable<Wind> getAllWindFixes() throws IOException {
        ArrayList<Wind> result = new ArrayList<Wind>();
        FeatureDataset[] featureDatasetArray = this.getDataSets();
        int n = featureDatasetArray.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureDataset dataSet = featureDatasetArray[n2];
            GridDatatype uGrid = null;
            GridDatatype vGrid = null;
            Iterator i = ((GridDataset)dataSet).getGrids().iterator();
            while (i.hasNext() && (uGrid == null || vGrid == null)) {
                GridDatatype grid = (GridDatatype)i.next();
                if (uComponentOfWindVariableSpecification.matches((VariableSimpleIF)grid.getVariable())) {
                    assert (this.isMetersPerSecond(this.getUnit(grid.getVariable()).get()));
                    uGrid = grid;
                    continue;
                }
                if (!vComponentOfWindVariableSpecification.matches((VariableSimpleIF)grid.getVariable())) continue;
                assert (this.isMetersPerSecond(this.getUnit(grid.getVariable()).get()));
                vGrid = grid;
            }
            if (uGrid != null && vGrid != null) {
                GridDatatype finalVGrid = vGrid;
                HashMap vGridDataCache = new HashMap();
                for (Wind wind : this.foreach(uGrid, (uGridData, timeIndex, index, timePoint, position) -> {
                    assert (Arrays.equals(index.getShape(), uGridData.getShape()));
                    try {
                        Array vGridData = (Array)vGridDataCache.get(timeIndex);
                        if (vGridData == null) {
                            vGridData = finalVGrid.readVolumeData(timeIndex);
                            vGridDataCache.put(timeIndex, vGridData);
                        }
                        double uComponentInMetersPerSecond = uGridData.getDouble(index);
                        double vComponentInMetersPerSecond = vGridData.getDouble(index);
                        Wind wind = !Double.isNaN(uComponentInMetersPerSecond) && !Double.isNaN(vComponentInMetersPerSecond) ? this.createWindFixFromUAndV(position, timePoint, uComponentInMetersPerSecond, vComponentInMetersPerSecond) : null;
                        return wind;
                    }
                    catch (Exception e) {
                        logger.log(Level.INFO, "Exception trying to compute wind from speed and direction", e);
                        return null;
                    }
                })) {
                    if (wind == null) continue;
                    result.add(wind);
                }
            }
            ++n2;
        }
        return result;
    }

    private Wind createWindFixFromUAndV(Position position, TimePoint timePoint, double uComponentInMetersPerSecond, double vComponentInMetersPerSecond) {
        double atan2 = Math.atan2(uComponentInMetersPerSecond, vComponentInMetersPerSecond);
        return new WindImpl(position, timePoint, (SpeedWithBearing)new MeterPerSecondSpeedWithDegreeBearingImpl(Math.sqrt(uComponentInMetersPerSecond * uComponentInMetersPerSecond + vComponentInMetersPerSecond * vComponentInMetersPerSecond), (Bearing)new RadianBearingImpl(atan2 > 0.0 ? atan2 : Math.PI * 2 + atan2)));
    }
}

