/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.grib.impl;

import com.sap.sailing.grib.GribWindField;
import com.sap.sailing.grib.GribWindFieldFactory;
import com.sap.sailing.grib.impl.AbstractGribWindFieldImpl;
import com.sap.sailing.grib.impl.SpeedAndDirectionWindField;
import com.sap.sailing.grib.impl.UVWindField;
import com.sap.sse.common.util.MappingIterable;
import com.sap.sse.util.LoggerAppender;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;

public class GribWindFieldFactoryImpl
implements GribWindFieldFactory {
    private static final Logger logger = Logger.getLogger(GribWindFieldFactoryImpl.class.getName());
    private static final Level DEFAULT_ERROR_LOG_LEVEL = Level.INFO;
    private final ReferenceQueue<GribWindField> referenceQueue = new ReferenceQueue();
    private Thread fileSystemCleaner;
    private final Map<WeakReference<GribWindField>, File> filesToCleanWhenGribWindFieldNoLongerUsed = new HashMap<WeakReference<GribWindField>, File>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDirectoryWhenWindFieldNoLongerStronglyReferenced(GribWindField windField, File directoryToRemove) {
        assert (directoryToRemove.isDirectory());
        GribWindFieldFactoryImpl gribWindFieldFactoryImpl = this;
        synchronized (gribWindFieldFactoryImpl) {
            boolean needToStartThread = this.filesToCleanWhenGribWindFieldNoLongerUsed.isEmpty();
            this.filesToCleanWhenGribWindFieldNoLongerUsed.put(new WeakReference<GribWindField>(windField, this.referenceQueue), directoryToRemove);
            if (needToStartThread && this.fileSystemCleaner == null) {
                this.fileSystemCleaner = new Thread(() -> {
                    boolean finished = false;
                    while (!finished) {
                        try {
                            Reference<GribWindField> ref = this.referenceQueue.remove();
                            finished = this.cleanup(ref);
                        }
                        catch (InterruptedException e) {
                            logger.log(Level.WARNING, "Interrupted while waiting for weak reference, giving up", e);
                            finished = true;
                        }
                    }
                }, "GRIB directory cleaner");
                this.fileSystemCleaner.setDaemon(true);
                this.fileSystemCleaner.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cleanup(Reference<? extends GribWindField> ref) {
        boolean finished;
        File dir;
        GribWindFieldFactoryImpl gribWindFieldFactoryImpl = this;
        synchronized (gribWindFieldFactoryImpl) {
            dir = this.filesToCleanWhenGribWindFieldNoLongerUsed.remove(ref);
            finished = this.filesToCleanWhenGribWindFieldNoLongerUsed.isEmpty();
            if (finished) {
                this.fileSystemCleaner = null;
            }
        }
        this.rm_rf(dir);
        return finished;
    }

    @Override
    public synchronized void shutdown() {
        for (WeakReference<GribWindField> ref : new ArrayList<WeakReference<GribWindField>>(this.filesToCleanWhenGribWindFieldNoLongerUsed.keySet())) {
            this.cleanup(ref);
        }
    }

    private void rm_rf(File dir) {
        assert (dir.isDirectory());
        File[] fileArray = dir.listFiles(f -> true);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f2 = fileArray[n2];
            if (f2.isDirectory()) {
                this.rm_rf(f2);
            } else {
                f2.delete();
            }
            ++n2;
        }
        dir.delete();
    }

    @Override
    public GribWindField createGribWindField(FeatureDataset ... dataSets) {
        AbstractGribWindFieldImpl result;
        if (UVWindField.handles(dataSets)) {
            result = new UVWindField(dataSets);
        } else if (SpeedAndDirectionWindField.handles(dataSets)) {
            result = new SpeedAndDirectionWindField(dataSets);
        } else {
            throw new IllegalArgumentException("Couldn't find a wind field implementation handling data set(s) " + dataSets);
        }
        return result;
    }

    @Override
    public GribWindField createGribWindField(Iterable<String> locations) throws IOException {
        return this.createGribWindField(logger, DEFAULT_ERROR_LOG_LEVEL, locations);
    }

    @Override
    public GribWindField createGribWindField(Logger logger, Level level, Iterable<String> locations) throws IOException {
        Formatter errorLog = this.createLogFormatter(logger, level);
        return this.createGribWindField(errorLog, locations);
    }

    @Override
    public GribWindField createGribWindField(Formatter errorLog, Iterable<String> locations) throws IOException {
        ArrayList<FeatureDataset> dataSets = new ArrayList<FeatureDataset>();
        for (String location : locations) {
            FeatureDataset dataSet = FeatureDatasetFactoryManager.open((FeatureType)FeatureType.ANY, (String)location, null, (Formatter)errorLog);
            dataSets.add(dataSet);
        }
        return this.createGribWindField(dataSets.toArray(new FeatureDataset[0]));
    }

    @Override
    public GribWindField createGribWindFieldFromFiles(Iterable<File> files) throws IOException {
        return this.createGribWindFieldFromFiles(logger, DEFAULT_ERROR_LOG_LEVEL, files);
    }

    @Override
    public GribWindField createGribWindFieldFromFiles(Logger logger, Level level, Iterable<File> files) throws IOException {
        return this.createGribWindFieldFromFiles(this.createLogFormatter(logger, level), files);
    }

    @Override
    public GribWindField createGribWindFieldFromFiles(Formatter errorLog, Iterable<File> files) throws IOException {
        return this.createGribWindField(errorLog, (Iterable<String>)new MappingIterable(files, f -> {
            try {
                return f.getCanonicalPath();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error obtaining GRIB file path", e);
                return null;
            }
        }));
    }

    @Override
    public GribWindField createGribWindFieldFromStreams(Map<InputStream, String> streamsAndFilenames) throws IOException {
        return this.createGribWindFieldFromStreams(logger, DEFAULT_ERROR_LOG_LEVEL, streamsAndFilenames);
    }

    @Override
    public GribWindField createGribWindFieldFromStreams(Logger logger, Level level, Map<InputStream, String> streamsAndFilenames) throws IOException {
        return this.createGribWindFieldFromStreams(this.createLogFormatter(logger, level), streamsAndFilenames);
    }

    @Override
    public GribWindField createGribWindFieldFromStreams(Formatter errorLog, Map<InputStream, String> streamsAndFilenames) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        for (Map.Entry<InputStream, String> e : streamsAndFilenames.entrySet()) {
            files.add(this.copyStreamToFile(e.getKey(), e.getValue()));
        }
        GribWindField result = this.createGribWindFieldFromFiles(errorLog, files);
        for (File file : files) {
            this.removeDirectoryWhenWindFieldNoLongerStronglyReferenced(result, file.getParentFile());
        }
        return result;
    }

    private File copyStreamToFile(InputStream s, String filename) throws IOException {
        Path tempDir = Files.createTempDirectory("gribcache", new FileAttribute[0]);
        Path filePath = tempDir.resolve(filename);
        Files.copy(s, filePath, new CopyOption[0]);
        return filePath.toFile();
    }

    @Override
    public Formatter createLogFormatter(Logger logger, Level level) {
        return new Formatter((Appendable)new LoggerAppender(level, logger));
    }
}

