/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.shared.subscription;

import java.io.Serializable;
import java.util.UUID;

public class SubscriptionPlanRole
implements Serializable {
    private static final long serialVersionUID = -4052966548617597414L;
    private final UUID roleId;
    private final UserQualificationMode userQualificationMode;
    private final GroupQualificationMode groupQualificationMode;
    private final UUID idOfExplicitGroupQualification;
    private final String explicitUserQualification;

    public SubscriptionPlanRole(UUID roleId, GroupQualificationMode groupQualificationMode, UserQualificationMode userQualificationMode) {
        this(roleId, groupQualificationMode, userQualificationMode, null, null);
    }

    public SubscriptionPlanRole(UUID roleId, GroupQualificationMode groupQualificationMode, UserQualificationMode userQualificationMode, String explicitUserQualification, UUID idOfExplicitGroupQualification) {
        if (explicitUserQualification != null && userQualificationMode != null && userQualificationMode != UserQualificationMode.NONE) {
            throw new IllegalArgumentException("Explicit user qualification provided, but user qualification mode " + (Object)((Object)userQualificationMode) + " hides it.");
        }
        if (idOfExplicitGroupQualification != null && groupQualificationMode != null && groupQualificationMode != GroupQualificationMode.NONE) {
            throw new IllegalArgumentException("Explicit groupo qualification provided, but group qualification mode " + (Object)((Object)groupQualificationMode) + " hides it.");
        }
        this.roleId = roleId;
        this.userQualificationMode = userQualificationMode;
        this.groupQualificationMode = groupQualificationMode;
        this.explicitUserQualification = explicitUserQualification;
        this.idOfExplicitGroupQualification = idOfExplicitGroupQualification;
    }

    public SubscriptionPlanRole(UUID roleId) {
        this(roleId, null, null, null, null);
    }

    public UUID getRoleId() {
        return this.roleId;
    }

    public UserQualificationMode getUserQualificationMode() {
        return this.userQualificationMode;
    }

    public GroupQualificationMode getGroupQualificationMode() {
        return this.groupQualificationMode;
    }

    public UUID getIdOfExplicitGroupQualification() {
        return this.idOfExplicitGroupQualification;
    }

    public String getExplicitUserQualification() {
        return this.explicitUserQualification;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.explicitUserQualification == null ? 0 : this.explicitUserQualification.hashCode());
        result = 31 * result + (this.groupQualificationMode == null ? 0 : this.groupQualificationMode.hashCode());
        result = 31 * result + (this.idOfExplicitGroupQualification == null ? 0 : this.idOfExplicitGroupQualification.hashCode());
        result = 31 * result + (this.roleId == null ? 0 : this.roleId.hashCode());
        result = 31 * result + (this.userQualificationMode == null ? 0 : this.userQualificationMode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubscriptionPlanRole other = (SubscriptionPlanRole)obj;
        if (this.explicitUserQualification == null ? other.explicitUserQualification != null : !this.explicitUserQualification.equals(other.explicitUserQualification)) {
            return false;
        }
        if (this.groupQualificationMode != other.groupQualificationMode) {
            return false;
        }
        if (this.idOfExplicitGroupQualification == null ? other.idOfExplicitGroupQualification != null : !this.idOfExplicitGroupQualification.equals(other.idOfExplicitGroupQualification)) {
            return false;
        }
        if (this.roleId == null ? other.roleId != null : !this.roleId.equals(other.roleId)) {
            return false;
        }
        return this.userQualificationMode == other.userQualificationMode;
    }

    public static enum GroupQualificationMode {
        NONE,
        DEFAULT_QUALIFIED_USER_TENANT,
        SUBSCRIBING_USER_DEFAULT_TENANT;

    }

    public static enum UserQualificationMode {
        NONE,
        SUBSCRIBING_USER;

    }
}

