/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.shared.impl;

import com.sap.sse.common.Util;
import com.sap.sse.security.shared.PermissionStringEncoder;
import com.sap.sse.security.shared.WildcardPermission;

public class WildcardPermissionEncoder
implements PermissionStringEncoder<WildcardPermission> {
    private static final char ESCAPE_CHARACTER = '\\';
    private static final char PART_DIVIDER_ENCODED = '/';
    private static final char SUBPART_DIVIDER_ENCODED = '|';
    private static final String hexDigits = "0123456789abcdef";

    @Override
    public String encodeAsPermissionPart(String s) {
        assert (":".length() == 1);
        assert (",".length() == 1);
        StringBuilder result = new StringBuilder();
        boolean inLeadingWhitespace = true;
        int firstTrailingWhitespace = s.length();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if ((inLeadingWhitespace || i >= firstTrailingWhitespace) && Character.isWhitespace(c)) {
                result.append(this.encodeWhitespace(c));
            } else {
                if (inLeadingWhitespace) {
                    inLeadingWhitespace = false;
                    firstTrailingWhitespace = s.length() - (s.substring(i).length() - s.substring(i).trim().length());
                }
                if (c == ":".charAt(0)) {
                    result.append('\\');
                    result.append('/');
                } else if (c == ",".charAt(0)) {
                    result.append('\\');
                    result.append('|');
                } else if (c == '\\') {
                    result.append('\\');
                    result.append('\\');
                } else {
                    result.append(c);
                }
            }
            ++i;
        }
        return result.toString();
    }

    private String encodeWhitespace(char c) {
        return String.valueOf('\\') + this.asTwoHexDigits(c);
    }

    private String asTwoHexDigits(char c) {
        char cAsInt = c;
        return "" + hexDigits.charAt(cAsInt / 16) + hexDigits.charAt(cAsInt % 16);
    }

    @Override
    public String decodePermissionPart(String permissionPart) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < permissionPart.length()) {
            char c = permissionPart.charAt(i);
            if (c == '\\') {
                assert (permissionPart.length() > i + 1);
                char next = permissionPart.charAt(++i);
                switch (next) {
                    case '/': {
                        result.append(":");
                        break;
                    }
                    case '|': {
                        result.append(",");
                        break;
                    }
                    case '\\': {
                        result.append('\\');
                        break;
                    }
                    default: {
                        assert (permissionPart.length() > i + 1);
                        result.append((char)Integer.parseInt("" + next + permissionPart.charAt(++i), 16));
                        break;
                    }
                }
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    @Override
    public String encodeStringList(String ... strings) {
        String[] firstPassResult = new String[strings.length];
        int i = 0;
        while (i < strings.length) {
            firstPassResult[i] = this.encodeAsPermissionPart(strings[i]);
            ++i;
        }
        String concatenatedFirstPassResult = Util.join((String)":", (String[])firstPassResult);
        return this.encodeAsPermissionPart(concatenatedFirstPassResult);
    }

    @Override
    public String[] decodeStringList(String stringEncodedWithEncodeStringList) {
        String decodedPartList = this.decodePermissionPart(stringEncodedWithEncodeStringList);
        String[] parts = decodedPartList.split(":");
        String[] result = new String[parts.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.decodePermissionPart(parts[i]);
            ++i;
        }
        return result;
    }

    public static String encode(String ... values) {
        WildcardPermissionEncoder encoder = new WildcardPermissionEncoder();
        return encoder.encodeStringList(values);
    }
}

