/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.shared.impl;

import com.sap.sse.security.shared.AbstractRole;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.RoleDefinition;
import com.sap.sse.security.shared.SecurityUser;
import com.sap.sse.security.shared.SecurityUserGroup;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.impl.AbstractUserReference;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class SecurityUserImpl<RD extends RoleDefinition, R extends AbstractRole<RD, G, ?>, G extends SecurityUserGroup<?>, P extends WildcardPermission>
extends AbstractUserReference
implements SecurityUser<RD, R, G> {
    private static final long serialVersionUID = -3639860207453072248L;
    private Set<WildcardPermission> permissions = new HashSet<WildcardPermission>();

    public SecurityUserImpl(String name) {
        this(name, new HashSet());
    }

    public SecurityUserImpl(String name, Iterable<P> permissions) {
        super(name);
        for (WildcardPermission permission : permissions) {
            this.permissions.add(permission);
        }
    }

    protected abstract Set<R> getRolesInternal();

    @Override
    public Iterable<R> getRoles() {
        return this.getRolesInternal();
    }

    @Override
    public boolean hasRole(R role) {
        return this.getRolesInternal().contains(role);
    }

    @Override
    public Iterable<WildcardPermission> getPermissions() {
        return this.permissions;
    }

    public void addRole(R role) {
        this.getRolesInternal().add(role);
    }

    public void removeRole(R role) {
        this.getRolesInternal().remove(role);
    }

    public void addPermission(P permission) {
        this.permissions.add((WildcardPermission)permission);
    }

    public void removePermission(P permission) {
        this.permissions.remove(permission);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getName()) + " (roles: " + this.getRoles() + ")";
    }

    @Override
    public Iterable<G> getUserGroups() {
        return Collections.emptyList();
    }

    @Override
    public QualifiedObjectIdentifier getIdentifier() {
        return this.getPermissionType().getQualifiedObjectIdentifier(this.getTypeRelativeObjectIdentifier());
    }

    public TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier() {
        return SecurityUserImpl.getTypeRelativeObjectIdentifier(this.getName());
    }

    @Override
    public HasPermissions getPermissionType() {
        return SecuredSecurityTypes.USER;
    }

    public static TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier(String userName) {
        return new TypeRelativeObjectIdentifier(new String[]{userName});
    }
}

