/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.shared.impl;

import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.WildcardPermission;

public class QualifiedObjectIdentifierImpl
implements QualifiedObjectIdentifier {
    private static final long serialVersionUID = -1749648443005614962L;
    private final String typeIdentifier;
    private final TypeRelativeObjectIdentifier typeRelativeObjectIdentifier;

    private QualifiedObjectIdentifierImpl(String qualifiedObjectIdentifierAsString) {
        int indexOfSeparator = qualifiedObjectIdentifierAsString.indexOf(47);
        if (indexOfSeparator < 0) {
            throw new IllegalArgumentException("Qualified object identifier must contain separator character /");
        }
        this.typeIdentifier = qualifiedObjectIdentifierAsString.substring(0, indexOfSeparator);
        String typeRelativeIdentifier = qualifiedObjectIdentifierAsString.substring(indexOfSeparator + 1);
        this.typeRelativeObjectIdentifier = TypeRelativeObjectIdentifier.fromEncodedString(typeRelativeIdentifier);
    }

    public QualifiedObjectIdentifierImpl(String typeIdentifier, TypeRelativeObjectIdentifier typeRelativeObjectIdentifier) {
        this.typeIdentifier = typeIdentifier;
        this.typeRelativeObjectIdentifier = typeRelativeObjectIdentifier;
    }

    public static QualifiedObjectIdentifier fromDBWithoutEscaping(String escapedId) {
        return new QualifiedObjectIdentifierImpl(escapedId);
    }

    @Override
    public String getTypeIdentifier() {
        return this.typeIdentifier;
    }

    @Override
    public TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier() {
        return this.typeRelativeObjectIdentifier;
    }

    @Override
    public String getStringPermission(HasPermissions.Action action) {
        return this.getPermission(action).toString();
    }

    @Override
    public WildcardPermission getPermission(HasPermissions.Action action) {
        return this.getPermission(action.name());
    }

    @Override
    public WildcardPermission getPermission(String actionName) {
        return WildcardPermission.builder().withTypeNames(this.getTypeIdentifier()).withActionNames(actionName).withIds(this.getTypeRelativeObjectIdentifier()).build();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getTypeIdentifier()) + '/' + this.getTypeRelativeObjectIdentifier();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.typeIdentifier == null ? 0 : this.typeIdentifier.hashCode());
        result = 31 * result + (this.typeRelativeObjectIdentifier == null ? 0 : this.typeRelativeObjectIdentifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QualifiedObjectIdentifierImpl other = (QualifiedObjectIdentifierImpl)obj;
        if (this.typeIdentifier == null ? other.typeIdentifier != null : !this.typeIdentifier.equals(other.typeIdentifier)) {
            return false;
        }
        return !(this.typeRelativeObjectIdentifier == null ? other.typeRelativeObjectIdentifier != null : !this.typeRelativeObjectIdentifier.equals(other.typeRelativeObjectIdentifier));
    }
}

