/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.shared;

import com.sap.sse.common.NamedWithID;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.RoleDefinition;
import com.sap.sse.security.shared.SecurityUserGroup;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.shared.impl.UserGroupImpl;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;

public abstract class SecurityUserGroupImpl<RD extends RoleDefinition>
implements NamedWithID,
WithQualifiedObjectIdentifier,
SecurityUserGroup<RD> {
    private static final long serialVersionUID = 1L;
    private UUID id;
    private String name;
    protected Map<RD, Boolean> roleDefinitionMap;

    public SecurityUserGroupImpl(UUID id, String name, Map<RD, Boolean> roleDefinitionMap) {
        this.id = id;
        this.name = name;
        this.roleDefinitionMap = roleDefinitionMap;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public Map<RD, Boolean> getRoleDefinitionMap() {
        return Collections.unmodifiableMap(this.roleDefinitionMap);
    }

    @Override
    public HasPermissions getPermissionType() {
        return SecuredSecurityTypes.USER_GROUP;
    }

    @Override
    public QualifiedObjectIdentifier getIdentifier() {
        return this.getPermissionType().getQualifiedObjectIdentifier(this.getTypeRelativeObjectIdentifier());
    }

    public TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier() {
        return UserGroupImpl.getTypeRelativeObjectIdentifier(this.getId());
    }

    public String toString() {
        return "SecurityUserGroupImpl [id=" + this.id + ", name=" + this.name + ", roleDefinitionMap=" + this.roleDefinitionMap + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SecurityUserGroupImpl other = (SecurityUserGroupImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

