/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.shared;

import com.sap.sse.common.Util;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.RoleDefinition;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class RoleDefinitionImpl
implements RoleDefinition {
    private static final long serialVersionUID = -402472324567793082L;
    private UUID id;
    private String name;
    private Set<WildcardPermission> permissions;

    protected RoleDefinitionImpl() {
    }

    public RoleDefinitionImpl(UUID id, String name) {
        this(id, name, new HashSet<WildcardPermission>());
    }

    public RoleDefinitionImpl(UUID id, String name, Iterable<WildcardPermission> permissions) {
        this.id = id;
        this.name = name;
        this.permissions = new HashSet<WildcardPermission>();
        Util.addAll(permissions, this.permissions);
    }

    public static RoleDefinition create(UUID id, String name, Iterable<WildcardPermission> permissions) {
        return new RoleDefinitionImpl(id, name, permissions);
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    public Set<WildcardPermission> getPermissions() {
        return Collections.unmodifiableSet(this.permissions);
    }

    @Override
    public void setPermissions(Iterable<WildcardPermission> permissions) {
        this.permissions = new HashSet<WildcardPermission>();
        Util.addAll(permissions, this.permissions);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RoleDefinitionImpl other = (RoleDefinitionImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return String.valueOf(this.name) + " (permissions: " + this.permissions + ")";
    }

    @Override
    public HasPermissions getPermissionType() {
        return SecuredSecurityTypes.ROLE_DEFINITION;
    }

    @Override
    public QualifiedObjectIdentifier getIdentifier() {
        return this.getPermissionType().getQualifiedObjectIdentifier(this.getTypeRelativeObjectIdentifier());
    }

    public TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier() {
        return RoleDefinitionImpl.getTypeRelativeObjectIdentifier(this);
    }

    public static TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier(RoleDefinition roleDefinition) {
        return new TypeRelativeObjectIdentifier(new String[]{RoleDefinitionImpl.getTypeRelativeObjectIdentifierAsString(roleDefinition)});
    }

    public static String getTypeRelativeObjectIdentifierAsString(RoleDefinition roleDefinition) {
        return roleDefinition.getIdAsString();
    }
}

