/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.shared;

import com.sap.sse.common.Util;
import com.sap.sse.security.shared.AbstractOwnership;
import com.sap.sse.security.shared.AbstractRole;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.RoleDefinition;
import com.sap.sse.security.shared.SecurityAccessControlList;
import com.sap.sse.security.shared.SecurityUser;
import com.sap.sse.security.shared.SecurityUserGroup;
import com.sap.sse.security.shared.UserReference;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.WrongPermissionFormatException;
import com.sap.sse.security.shared.impl.AccessControlList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public class PermissionChecker {
    private static final BiFunction<WildcardPermission, WildcardPermission, Boolean> impliesChecker = WildcardPermission::implies;
    private static final BiFunction<WildcardPermission, WildcardPermission, Boolean> impliesAnyChecker = WildcardPermission::impliesAny;

    private static <U extends SecurityUser<?, ?, G>, G extends SecurityUserGroup<?>> Iterable<G> getGroupsOfUser(U user) {
        return user == null ? Collections.emptySet() : user.getUserGroups();
    }

    public static <RD extends RoleDefinition, R extends AbstractRole<RD, G, UR>, O extends AbstractOwnership<G, UR>, UR extends UserReference, U extends SecurityUser<RD, R, G>, G extends SecurityUserGroup<RD>, A extends SecurityAccessControlList<G>> boolean isPermitted(WildcardPermission permission, U user, U allUser, O ownership, A acl) {
        return PermissionChecker.isPermitted(permission, user, PermissionChecker.getGroupsOfUser(user), allUser, PermissionChecker.getGroupsOfUser(allUser), ownership, acl, null);
    }

    public static <RD extends RoleDefinition, R extends AbstractRole<RD, G, UR>, O extends AbstractOwnership<G, UR>, UR extends UserReference, U extends SecurityUser<RD, R, G>, G extends SecurityUserGroup<RD>, A extends SecurityAccessControlList<G>> boolean isPermitted(WildcardPermission permission, U user, U allUser, O ownership, A acl, Iterable<R> additionalRoles) {
        return PermissionChecker.isPermitted(permission, user, PermissionChecker.getGroupsOfUser(user), allUser, PermissionChecker.getGroupsOfUser(allUser), ownership, acl, additionalRoles);
    }

    public static <RD extends RoleDefinition, R extends AbstractRole<RD, G, UR>, O extends AbstractOwnership<G, UR>, UR extends UserReference, U extends SecurityUser<RD, R, G>, G extends SecurityUserGroup<RD>, A extends SecurityAccessControlList<G>> boolean isPermitted(WildcardPermission permission, U user, Iterable<G> groupsOfWhichUserIsMember, U allUser, Iterable<G> groupsOfWhichAllUserIsMember, O ownership, A acl, Iterable<R> additionalRoles) {
        PermissionState anonymous;
        PermissionState result = PermissionChecker.checkAcl(permission, groupsOfWhichUserIsMember, groupsOfWhichAllUserIsMember, acl);
        if (result == PermissionState.NONE && (anonymous = PermissionChecker.checkUserPermissions(permission, allUser, groupsOfWhichAllUserIsMember, ownership, impliesChecker, additionalRoles, true, false)) == PermissionState.GRANTED) {
            result = anonymous;
        }
        if (result == PermissionState.NONE) {
            result = PermissionChecker.checkUserPermissions(permission, user, groupsOfWhichUserIsMember, ownership, impliesChecker, additionalRoles, true, false);
        }
        return result == PermissionState.GRANTED;
    }

    private static <A extends SecurityAccessControlList<G>, G extends SecurityUserGroup<?>> PermissionState checkAcl(WildcardPermission permission, Iterable<G> groupsOfWhichUserIsMember, Iterable<G> groupsOfWhichAllUserIsMember, A acl) {
        List<Set<String>> parts = permission.getParts();
        return PermissionChecker.checkAcl(permission, groupsOfWhichUserIsMember, groupsOfWhichAllUserIsMember, acl, parts);
    }

    private static <G extends SecurityUserGroup<?>, A extends SecurityAccessControlList<G>> PermissionState checkAcl(WildcardPermission permission, Iterable<G> groupsOfWhichUserIsMember, Iterable<G> groupsOfWhichAllUserIsMember, A acl, List<Set<String>> parts) {
        if (parts.get(0).size() != 1) {
            throw new WrongPermissionFormatException(permission);
        }
        PermissionState result = PermissionState.NONE;
        if (acl != null) {
            String action;
            if (parts.size() < 2) {
                action = "*";
            } else {
                if (parts.get(1).size() > 1) {
                    throw new IllegalArgumentException("Permission to check must not have more than one sub-part: " + parts.get(1));
                }
                action = (String)parts.get(1).toArray()[0];
            }
            HashSet allGroups = new HashSet();
            Util.addAll(groupsOfWhichUserIsMember, allGroups);
            Util.addAll(groupsOfWhichAllUserIsMember, allGroups);
            result = acl.hasPermission(action, allGroups);
        }
        return result;
    }

    public static <RD extends RoleDefinition, R extends AbstractRole<RD, G, U>, O extends AbstractOwnership<G, U>, U extends SecurityUser<RD, R, G>, G extends SecurityUserGroup<RD>, A extends SecurityAccessControlList<G>> boolean ownsUserASpecificRole(U user, U allUser, O ownership, String requiredRoleName) {
        assert (requiredRoleName != null);
        return PermissionChecker.ownsUserASpecificRole(user, ownership, requiredRoleName) || PermissionChecker.ownsUserASpecificRole(allUser, ownership, requiredRoleName);
    }

    private static <RD extends RoleDefinition, R extends AbstractRole<RD, G, U>, O extends AbstractOwnership<G, U>, U extends SecurityUser<RD, R, G>, G extends SecurityUserGroup<RD>, A extends SecurityAccessControlList<G>> boolean ownsUserASpecificRole(U user, O ownership, String requiredRoleName) {
        if (user == null) {
            return false;
        }
        for (AbstractRole roleOwnedByUser : user.getRoles()) {
            if (!roleOwnedByUser.getName().equals(requiredRoleName)) continue;
            if (roleOwnedByUser.getQualifiedForTenant() == null && roleOwnedByUser.getQualifiedForUser() == null) {
                return true;
            }
            if (ownership == null || ownership.getTenantOwner() == null && ownership.getUserOwner() == null) continue;
            if (roleOwnedByUser.getQualifiedForTenant() != null && roleOwnedByUser.getQualifiedForTenant().equals(ownership.getTenantOwner())) {
                return true;
            }
            if (roleOwnedByUser.getQualifiedForUser() == null || !((SecurityUser)roleOwnedByUser.getQualifiedForUser()).equals(ownership.getUserOwner())) continue;
            return true;
        }
        return false;
    }

    public static <RD extends RoleDefinition, R extends AbstractRole<RD, G, UR>, O extends AbstractOwnership<G, UR>, UR extends UserReference, U extends SecurityUser<RD, R, G>, G extends SecurityUserGroup<RD>, A extends SecurityAccessControlList<G>> boolean checkMetaPermission(WildcardPermission permission, Iterable<? extends HasPermissions> allPermissionTypes, U user, U allUser, O ownership, AclResolver<A, O> aclResolver) {
        return PermissionChecker.checkMetaPermissionInternal(permission, allPermissionTypes, user, allUser, wp -> ownership, aclResolver);
    }

    public static <RD extends RoleDefinition, R extends AbstractRole<RD, G, UR>, O extends AbstractOwnership<G, UR>, UR extends UserReference, U extends SecurityUser<RD, R, G>, G extends SecurityUserGroup<RD>, A extends SecurityAccessControlList<G>> boolean checkMetaPermissionWithOwnershipResolution(WildcardPermission permission, Iterable<? extends HasPermissions> allPermissionTypes, U user, U allUser, Function<QualifiedObjectIdentifier, O> ownershipResolver, AclResolver<A, O> aclResolver) {
        return PermissionChecker.checkMetaPermissionInternal(permission, allPermissionTypes, user, allUser, wp -> {
            AbstractOwnership ownership;
            Iterable<QualifiedObjectIdentifier> qualifiedObjectIdentifiers = wp.getQualifiedObjectIdentifiers();
            Iterator<QualifiedObjectIdentifier> iterator = qualifiedObjectIdentifiers.iterator();
            if (!iterator.hasNext()) {
                ownership = null;
            } else {
                QualifiedObjectIdentifier firstIdentifier = iterator.next();
                ownership = iterator.hasNext() || firstIdentifier == null ? null : (AbstractOwnership)ownershipResolver.apply(firstIdentifier);
            }
            return ownership;
        }, aclResolver);
    }

    private static <RD extends RoleDefinition, R extends AbstractRole<RD, G, UR>, O extends AbstractOwnership<G, UR>, UR extends UserReference, U extends SecurityUser<RD, R, G>, G extends SecurityUserGroup<RD>, A extends SecurityAccessControlList<G>> boolean checkMetaPermissionInternal(WildcardPermission permission, Iterable<? extends HasPermissions> allPermissionTypes, U user, U allUser, Function<WildcardPermission, O> ownershipResolver, AclResolver<A, O> aclResolver) {
        assert (permission != null);
        assert (allPermissionTypes != null);
        Set<WildcardPermission> effectivePermissionsToCheck = PermissionChecker.expandSingleWildcardPermissionToDistinctPermissions(permission, allPermissionTypes, true);
        Iterable groupsOfUser = PermissionChecker.getGroupsOfUser(user);
        Iterable groupsOfAllUser = PermissionChecker.getGroupsOfUser(allUser);
        HashMap<Util.Triple, Iterable<AccessControlList>> typesAndIdsAndOwnershipsWithFullSetOfAcls = new HashMap<Util.Triple, Iterable<AccessControlList>>();
        for (WildcardPermission effectiveWildcardPermissionToCheck : effectivePermissionsToCheck) {
            boolean identifierWildcard;
            Set<Object> identifiers;
            AbstractOwnership ownership = (AbstractOwnership)ownershipResolver.apply(effectiveWildcardPermissionToCheck);
            List<Set<String>> wildcardPermissionParts = effectiveWildcardPermissionToCheck.getParts();
            String type = wildcardPermissionParts.get(0).iterator().next();
            if (wildcardPermissionParts.size() >= 3) {
                identifiers = wildcardPermissionParts.get(2);
                identifierWildcard = "*".equals(identifiers.iterator().next());
            } else {
                identifiers = Collections.emptySet();
                identifierWildcard = true;
            }
            Util.Triple collationKeyBasedOnTypeAndObjectIdAndOwnership = new Util.Triple((Object)type, identifiers, (Object)ownership);
            Iterable denyingAclsFromPreviousRunForSameTypeAndObjectIds = (Iterable)typesAndIdsAndOwnershipsWithFullSetOfAcls.get(collationKeyBasedOnTypeAndObjectIdAndOwnership);
            Iterable<AccessControlList> denyingAcls = aclResolver.resolveDenyingAclsAndCheckIfAnyMatches(ownership, type, identifierWildcard ? null : identifiers, acl -> PermissionChecker.checkAcl(effectiveWildcardPermissionToCheck, groupsOfUser, groupsOfAllUser, acl) == PermissionState.REVOKED, denyingAclsFromPreviousRunForSameTypeAndObjectIds);
            if (denyingAcls == null) {
                return false;
            }
            if (denyingAclsFromPreviousRunForSameTypeAndObjectIds == null) {
                typesAndIdsAndOwnershipsWithFullSetOfAcls.put(collationKeyBasedOnTypeAndObjectIdAndOwnership, denyingAcls);
            }
            if (PermissionChecker.checkUserPermissions(effectiveWildcardPermissionToCheck, user, groupsOfUser, ownership, impliesChecker, null, true, true) == PermissionState.GRANTED || PermissionChecker.checkUserPermissions(effectiveWildcardPermissionToCheck, allUser, groupsOfAllUser, ownership, impliesChecker, null, true, true) == PermissionState.GRANTED) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static Set<WildcardPermission> expandSingleWildcardPermissionToDistinctPermissions(WildcardPermission permission, Iterable<? extends HasPermissions> allPermissionTypes, boolean expandToSingleIds) {
        boolean isIdPartWildcard;
        Set<String> idParts;
        boolean isActionPartWildcard;
        Set<String> actionParts;
        boolean isTypePartWildcard;
        Set<String> typeParts;
        List<Set<String>> parts = permission.getParts();
        if (parts.size() >= 1) {
            typeParts = parts.get(0);
            isTypePartWildcard = typeParts.isEmpty() || typeParts.contains("*");
        } else {
            typeParts = null;
            isTypePartWildcard = true;
        }
        if (parts.size() >= 2) {
            actionParts = parts.get(1);
            isActionPartWildcard = actionParts.isEmpty() || actionParts.contains("*");
        } else {
            actionParts = null;
            isActionPartWildcard = true;
        }
        if (parts.size() >= 3) {
            idParts = parts.get(2);
            isIdPartWildcard = idParts.isEmpty() || idParts.contains("*");
        } else {
            idParts = null;
            isIdPartWildcard = true;
        }
        HashMap<String, HasPermissions> allPermissionTypesByName = new HashMap<String, HasPermissions>();
        for (HasPermissions hasPermissions : allPermissionTypes) {
            allPermissionTypesByName.put(hasPermissions.getName(), hasPermissions);
        }
        if (isIdPartWildcard) {
            Set<String> set = Collections.singleton("");
        } else if (expandToSingleIds) {
            Set<String> set = idParts;
        } else {
            Set<String> set = Collections.singleton(Util.joinStrings((String)",", idParts));
        }
        Set<String> effectiveTypePartsToCheck = isTypePartWildcard ? allPermissionTypesByName.keySet() : typeParts;
        HashSet<WildcardPermission> effectivePermissionsToCheck = new HashSet<WildcardPermission>();
        for (String typePart : effectiveTypePartsToCheck) {
            Set<String> effectiveActionPartsToCheck;
            HasPermissions hasPermissions = (HasPermissions)allPermissionTypesByName.get(typePart);
            if (hasPermissions == null) {
                effectiveActionPartsToCheck = actionParts;
            } else {
                effectiveActionPartsToCheck = new HashSet<String>();
                HasPermissions.Action[] actionArray = hasPermissions.getAvailableActions();
                int n = actionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    HasPermissions.Action action = actionArray[n2];
                    if (isActionPartWildcard || actionParts.contains(action.name())) {
                        effectiveActionPartsToCheck.add(action.name());
                    }
                    ++n2;
                }
            }
            if (effectiveActionPartsToCheck == null) continue;
            for (String actionPart : effectiveActionPartsToCheck) {
                void var11_16;
                for (String idPart : var11_16) {
                    String idSuffix = idPart.isEmpty() ? "" : ":" + idPart;
                    effectivePermissionsToCheck.add(new WildcardPermission(String.valueOf(typePart) + ":" + actionPart + idSuffix));
                }
            }
        }
        return effectivePermissionsToCheck;
    }

    public static <RD extends RoleDefinition, R extends AbstractRole<RD, G, UR>, O extends AbstractOwnership<G, UR>, UR extends UserReference, U extends SecurityUser<RD, R, G>, G extends SecurityUserGroup<RD>, A extends SecurityAccessControlList<G>> boolean hasUserAnyPermission(WildcardPermission permission, Iterable<? extends HasPermissions> allPermissionTypes, U user, U allUser, O ownership) {
        assert (permission != null);
        assert (allPermissionTypes != null);
        Set<WildcardPermission> effectivePermissionsToCheck = PermissionChecker.expandSingleWildcardPermissionToDistinctPermissions(permission, allPermissionTypes, false);
        for (WildcardPermission effectiveWildcardPermissionToCheck : effectivePermissionsToCheck) {
            if (PermissionChecker.checkUserPermissions(effectiveWildcardPermissionToCheck, user, PermissionChecker.getGroupsOfUser(user), ownership, impliesAnyChecker, null, false, false) != PermissionState.GRANTED && PermissionChecker.checkUserPermissions(effectiveWildcardPermissionToCheck, allUser, PermissionChecker.getGroupsOfUser(allUser), ownership, impliesAnyChecker, null, false, false) != PermissionState.GRANTED) continue;
            return true;
        }
        return false;
    }

    private static <RD extends RoleDefinition, R extends AbstractRole<RD, G, UR>, O extends AbstractOwnership<G, UR>, UR extends UserReference, U extends SecurityUser<RD, R, G>, G extends SecurityUserGroup<RD>, A extends SecurityAccessControlList<G>> PermissionState checkUserPermissions(WildcardPermission permission, U user, Iterable<G> groupsOfWhichUserIsMember, O ownership, BiFunction<WildcardPermission, WildcardPermission, Boolean> permissionChecker, Iterable<R> additionalRoles, boolean matchOnlyNonQualifiedRolesIfNoOwnershipIsGiven, boolean matchOnlyTransitiveRoles) {
        PermissionState result;
        block8: {
            block7: {
                boolean userIsMemberOfGroup;
                result = PermissionState.NONE;
                if (result == PermissionState.NONE && user != null) {
                    for (WildcardPermission directPermission : user.getPermissions()) {
                        if (!permissionChecker.apply(directPermission, permission).booleanValue()) continue;
                        result = PermissionState.GRANTED;
                        break;
                    }
                }
                if (ownership == null || ownership.getTenantOwner() == null) break block7;
                G tenantOwner = ownership.getTenantOwner();
                if (!PermissionChecker.isPermissionGrantedByGroup(permission, tenantOwner, userIsMemberOfGroup = Util.contains(groupsOfWhichUserIsMember, tenantOwner), permissionChecker)) break block8;
                result = PermissionState.GRANTED;
                break block8;
            }
            if (!matchOnlyNonQualifiedRolesIfNoOwnershipIsGiven) {
                for (SecurityUserGroup groupToCheck : groupsOfWhichUserIsMember) {
                    if (!PermissionChecker.isPermissionGrantedByGroup(permission, groupToCheck, true, permissionChecker)) continue;
                    result = PermissionState.GRANTED;
                    break;
                }
            }
        }
        if (result == PermissionState.NONE && user != null) {
            Iterable<R> userRoles = user.getRoles();
            HashSet withAdditionalRoles = new HashSet();
            userRoles.forEach(withAdditionalRoles::add);
            if (additionalRoles != null) {
                additionalRoles.forEach(withAdditionalRoles::add);
            }
            for (AbstractRole role : withAdditionalRoles) {
                if (!PermissionChecker.implies(role, permission, ownership, permissionChecker, matchOnlyNonQualifiedRolesIfNoOwnershipIsGiven, matchOnlyTransitiveRoles)) continue;
                result = PermissionState.GRANTED;
                break;
            }
        }
        return result;
    }

    private static <RD extends RoleDefinition, U extends SecurityUser<RD, ?, G>, G extends SecurityUserGroup<RD>> boolean isPermissionGrantedByGroup(WildcardPermission permission, G groupToCheck, boolean userIsMemberOfGroup, BiFunction<WildcardPermission, WildcardPermission, Boolean> permissionChecker) {
        for (Map.Entry<RD, Boolean> entry : groupToCheck.getRoleDefinitionMap().entrySet()) {
            if (!Boolean.TRUE.equals(entry.getValue()) && !userIsMemberOfGroup) continue;
            RoleDefinition roleDefinition = (RoleDefinition)entry.getKey();
            for (WildcardPermission grantedPermission : roleDefinition.getPermissions()) {
                if (!permissionChecker.apply(grantedPermission, permission).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    private static <RD extends RoleDefinition, R extends AbstractRole<RD, G, UR>, O extends AbstractOwnership<G, UR>, UR extends UserReference, U extends SecurityUser<RD, R, G>, G extends SecurityUserGroup<RD>, A extends SecurityAccessControlList<G>> boolean implies(R role, WildcardPermission permission, O ownership, BiFunction<WildcardPermission, WildcardPermission, Boolean> permissionChecker, boolean matchOnlyNonQualifiedRolesIfNoOwnershipIsGiven, boolean matchOnlyTransitiveRoles) {
        boolean result;
        boolean ownershipIsGiven;
        boolean roleIsTenantQualified = role.getQualifiedForTenant() != null;
        boolean roleIsUserQualified = role.getQualifiedForUser() != null;
        boolean bl = ownershipIsGiven = ownership != null && (ownership.getTenantOwner() != null || ownership.getUserOwner() != null);
        if (matchOnlyTransitiveRoles && !role.isTransitive().booleanValue()) {
            return false;
        }
        boolean permissionsApply = roleIsTenantQualified || roleIsUserQualified ? (!ownershipIsGiven ? !matchOnlyNonQualifiedRolesIfNoOwnershipIsGiven : !(roleIsTenantQualified && !Util.equalsWithNull(role.getQualifiedForTenant(), ownership.getTenantOwner()) || roleIsUserQualified && !PermissionChecker.isSameUser(role.getQualifiedForUser(), ownership.getUserOwner()))) : true;
        if (permissionsApply) {
            result = false;
            for (WildcardPermission rolePermission : role.getPermissions()) {
                if (!permissionChecker.apply(rolePermission, permission).booleanValue()) continue;
                result = true;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }

    public static boolean isSameUser(UserReference user1, UserReference user2) {
        if (user1 == user2) {
            return true;
        }
        if (user1 == null || user2 == null) {
            return false;
        }
        return user1.getName().equals(user2.getName());
    }

    public static interface AclResolver<A extends SecurityAccessControlList<?>, O extends AbstractOwnership<?, ?>> {
        public Iterable<AccessControlList> resolveDenyingAclsAndCheckIfAnyMatches(O var1, String var2, Iterable<String> var3, Predicate<A> var4, Iterable<AccessControlList> var5);
    }

    public static enum PermissionState {
        GRANTED,
        REVOKED,
        NONE;

    }
}

