/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.shared;

import com.sap.sse.common.Util;
import com.sap.sse.security.shared.RoleDefinition;
import com.sap.sse.security.shared.SecurityUserGroupImpl;
import com.sap.sse.security.shared.UserReference;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public abstract class AbstractUserGroupImpl<U extends UserReference, RD extends RoleDefinition>
extends SecurityUserGroupImpl<RD> {
    private static final long serialVersionUID = 5449819084645794859L;
    private Set<U> users;

    protected AbstractUserGroupImpl(UUID id, String name, Set<U> users, Map<RD, Boolean> roleDefinitionMap) {
        super(id, name, roleDefinitionMap);
        this.users = users;
    }

    public Iterable<U> getUsers() {
        return this.users;
    }

    public void add(U user) {
        this.users.add(user);
    }

    public void remove(U user) {
        this.users.remove(user);
    }

    public boolean contains(U user) {
        return this.users.contains(user);
    }

    public Boolean put(RD roleDefinition, boolean forAll) {
        return this.roleDefinitionMap.put(roleDefinition, forAll);
    }

    public void remove(RD roleDefinition) {
        this.roleDefinitionMap.remove(roleDefinition);
    }

    @Override
    public String toString() {
        return "User group " + this.getName() + ", " + Util.size(this.getUsers()) + " users";
    }
}

