/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.shared;

import com.sap.sse.security.shared.SecurityUserGroup;
import com.sap.sse.security.shared.UserReference;
import java.io.Serializable;

public abstract class AbstractOwnership<G extends SecurityUserGroup<?>, U extends UserReference>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private U userOwner;
    private G tenantOwner;

    public AbstractOwnership(U userOwner, G tenantOwner) {
        this.userOwner = userOwner;
        this.tenantOwner = tenantOwner;
    }

    public U getUserOwner() {
        return this.userOwner;
    }

    public G getTenantOwner() {
        return this.tenantOwner;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tenantOwner == null ? 0 : this.tenantOwner.hashCode());
        result = 31 * result + (this.userOwner == null ? 0 : this.userOwner.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractOwnership other = (AbstractOwnership)obj;
        if (this.tenantOwner == null ? other.tenantOwner != null : !this.tenantOwner.equals(other.tenantOwner)) {
            return false;
        }
        return !(this.userOwner == null ? other.userOwner != null : !this.userOwner.equals(other.userOwner));
    }

    public String toString() {
        return "AbstractOwnership [userOwner=" + this.userOwner + ", tenantOwner=" + this.tenantOwner + "]";
    }
}

