/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.manage2sail.resultimport;

import com.sap.sailing.domain.common.RegattaScoreCorrections;
import com.sap.sailing.domain.common.ScoreCorrectionProvider;
import com.sap.sailing.manage2sail.resultimport.AbstractManage2SailProvider;
import com.sap.sailing.manage2sail.resultimport.Manage2SailResultDocumentProvider;
import com.sap.sailing.resultimport.ResultDocumentDescriptor;
import com.sap.sailing.resultimport.ResultDocumentProvider;
import com.sap.sailing.resultimport.ResultUrlRegistry;
import com.sap.sailing.xrr.resultimport.Parser;
import com.sap.sailing.xrr.resultimport.ParserFactory;
import com.sap.sailing.xrr.schema.RegattaResults;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ScoreCorrectionProviderImpl
extends AbstractManage2SailProvider
implements ScoreCorrectionProvider {
    private static final Logger logger = Logger.getLogger(ScoreCorrectionProviderImpl.class.getName());
    private static final long serialVersionUID = 222663322974305822L;
    private final ResultDocumentProvider documentProvider;

    public ScoreCorrectionProviderImpl(ResultDocumentProvider documentProvider, ParserFactory parserFactory, ResultUrlRegistry resultUrlRegistry) {
        super(parserFactory, resultUrlRegistry);
        this.documentProvider = documentProvider;
    }

    public ScoreCorrectionProviderImpl(ParserFactory parserFactory, ResultUrlRegistry resultUrlRegistry) {
        super(parserFactory, resultUrlRegistry);
        this.documentProvider = new Manage2SailResultDocumentProvider(this);
    }

    public String getName() {
        return "Manage2Sail XRR Result Importer";
    }

    public Map<String, Set<Util.Pair<String, TimePoint>>> getHasResultsForBoatClassFromDateByEventName() throws URISyntaxException, SAXException, ParserConfigurationException {
        HashMap<String, Set<Util.Pair<String, TimePoint>>> result = new HashMap<String, Set<Util.Pair<String, TimePoint>>>();
        try {
            for (ResultDocumentDescriptor resultDocDescr : this.documentProvider.getResultDocumentDescriptors()) {
                HashSet<Util.Pair> eventResultsSet;
                String eventName = resultDocDescr.getEventName() != null ? resultDocDescr.getEventName() : resultDocDescr.getRegattaName();
                String boatClass = resultDocDescr.getBoatClass();
                if (boatClass == null || eventName == null) continue;
                if (resultDocDescr.getCompetitorGenderType() != null) {
                    boatClass = String.valueOf(boatClass) + ", " + resultDocDescr.getCompetitorGenderType().name();
                }
                if ((eventResultsSet = (HashSet<Util.Pair>)result.get(eventName)) == null) {
                    eventResultsSet = new HashSet<Util.Pair>();
                    result.put(eventName, eventResultsSet);
                }
                eventResultsSet.add(new Util.Pair((Object)boatClass, (Object)resultDocDescr.getLastModified()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public RegattaScoreCorrections getScoreCorrections(String eventName, String boatClassName, TimePoint timePointPublished) throws IOException, SAXException, ParserConfigurationException, URISyntaxException {
        Parser parser = this.resolveParser(eventName, boatClassName, timePointPublished);
        try {
            RegattaResults regattaResults = parser.parse();
            return parser.getRegattaScoreCorrections(regattaResults, (ScoreCorrectionProvider)this, Optional.of(eventName), Optional.of(boatClassName));
        }
        catch (JAXBException e) {
            logger.info("Parse error during XRR import. Ignoring document " + parser.toString());
            logger.throwing(ScoreCorrectionProviderImpl.class.getName(), "getHasResultsForBoatClassFromDateByEventName", e);
            return null;
        }
    }

    public RegattaScoreCorrections getScoreCorrections(InputStream inputStream) throws Exception {
        Parser parser = this.getParserFactory().createParser(inputStream, inputStream.toString());
        RegattaResults regattaResults = parser.parse();
        return parser.getRegattaScoreCorrections(regattaResults, (ScoreCorrectionProvider)this, Optional.empty(), Optional.empty());
    }

    private Parser resolveParser(String eventName, String boatClassName, TimePoint timePointPublished) throws IOException, URISyntaxException, SAXException, ParserConfigurationException {
        Parser result = null;
        for (ResultDocumentDescriptor resultDocDescr : this.documentProvider.getResultDocumentDescriptors()) {
            String boatClassAndGenderType = resultDocDescr.getBoatClass();
            if (resultDocDescr.getCompetitorGenderType() != null) {
                boatClassAndGenderType = String.valueOf(boatClassAndGenderType) + ", " + resultDocDescr.getCompetitorGenderType().name();
            }
            if (!eventName.equals(resultDocDescr.getEventName()) || !boatClassName.equals(boatClassAndGenderType) || !Util.equalsWithNull((Object)resultDocDescr.getLastModified(), (Object)timePointPublished)) continue;
            result = this.getParserFactory().createParser(resultDocDescr.getInputStream(), resultDocDescr.getEventName());
            break;
        }
        return result;
    }
}

