/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.common.shared;

import com.sap.sse.common.Util;

public class ShardTargetGroupName {
    public static final String TAG_KEY = "shardname";
    static final String NAMESEPARATOR = "--";
    static final String SEPARATOR = "-";
    private final String shardName;
    private final String targetGroupname;

    private ShardTargetGroupName(String shardName, String targetGroupname) {
        this.shardName = shardName;
        this.targetGroupname = targetGroupname;
    }

    public static ShardTargetGroupName parse(String shardTargetGroupName, String tagString) {
        String shardname;
        assert (ShardTargetGroupName.isValidShardTargetGroupName(shardTargetGroupName));
        if (Util.hasLength((String)tagString)) {
            shardname = tagString;
        } else {
            int lastIndexExclusiveToSearchForSeparator = shardTargetGroupName.contains(NAMESEPARATOR) ? shardTargetGroupName.indexOf(NAMESEPARATOR) : shardTargetGroupName.length();
            int idxHyphen1 = shardTargetGroupName.substring(0, lastIndexExclusiveToSearchForSeparator).lastIndexOf(SEPARATOR);
            shardname = shardTargetGroupName.substring(idxHyphen1 + 1);
        }
        return new ShardTargetGroupName(shardname, shardTargetGroupName);
    }

    public static ShardTargetGroupName create(String replicaSetName, String shardName, String targetGroupNamePrefix) throws IllegalArgumentException {
        String targetGroupName;
        if (!ShardTargetGroupName.isValidTargetGroupNamePrefix(targetGroupNamePrefix)) {
            throw new IllegalArgumentException("Target group name prefix " + targetGroupNamePrefix + " is not allowed");
        }
        if (!shardName.matches("[a-zA-Z0-9]*")) {
            throw new IllegalArgumentException("Only a-z, A-Z and 0-9 characters are allowed in shard name");
        }
        if (shardName.endsWith("-m") || shardName.endsWith("-TMP")) {
            throw new IllegalArgumentException("-m and -TMP are not allowed at the end of shard names");
        }
        String targetGroupNameBySimpleConcatenation = String.valueOf(targetGroupNamePrefix) + replicaSetName + SEPARATOR + shardName;
        if (targetGroupNameBySimpleConcatenation.length() <= 32) {
            targetGroupName = targetGroupNameBySimpleConcatenation;
        } else {
            String targetGroupNamePrefixForElidedShardNameMiddle = String.valueOf(targetGroupNamePrefix) + replicaSetName + SEPARATOR;
            if (targetGroupNamePrefixForElidedShardNameMiddle.length() + NAMESEPARATOR.length() >= 32) {
                throw new IllegalArgumentException("Cannot add shard name prefix/postfix to replica set name " + replicaSetName + " as it would exceed the maximum target group name limit of " + 32 + " characters");
            }
            int remainingCharactersAfterAddingNameSeparator = 32 - targetGroupNamePrefixForElidedShardNameMiddle.length() - NAMESEPARATOR.length();
            int prefixLength = remainingCharactersAfterAddingNameSeparator / 2 + remainingCharactersAfterAddingNameSeparator % 2;
            int postfixLength = remainingCharactersAfterAddingNameSeparator / 2;
            targetGroupName = String.valueOf(targetGroupNamePrefix) + replicaSetName + SEPARATOR + shardName.substring(0, prefixLength) + NAMESEPARATOR + shardName.substring(shardName.length() - postfixLength);
        }
        assert (ShardTargetGroupName.isValidShardTargetGroupName(targetGroupName));
        return new ShardTargetGroupName(shardName, targetGroupName);
    }

    public String getName() {
        return this.shardName;
    }

    public String getTargetGroupName() {
        return this.targetGroupname;
    }

    public String getShardName() {
        return this.shardName;
    }

    public static boolean isValidTargetGroupNamePrefix(String prefix) {
        return !prefix.contains(NAMESEPARATOR) && prefix.length() + 1 + SEPARATOR.length() + 1 <= 32;
    }

    public static boolean isValidShardTargetGroupName(String name) {
        return name.length() <= 32 && !name.endsWith("-m") && !name.endsWith("-TMP") && name.contains(SEPARATOR) && (!name.contains(NAMESEPARATOR) || name.indexOf(SEPARATOR, name.indexOf(NAMESEPARATOR) + NAMESEPARATOR.length()) < 0);
    }
}

