/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.ess40.resultimport.impl;

import com.sap.sailing.domain.common.RegattaScoreCorrections;
import com.sap.sailing.ess40.resultimport.impl.ScoreCorrectionForCompetitorInRaceImpl;
import com.sap.sse.common.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ScoreCorrectionForRaceImpl
implements RegattaScoreCorrections.ScoreCorrectionsForRace {
    private final int raceNumberStartingWithOne;
    private final Map<String, RegattaScoreCorrections.ScoreCorrectionForCompetitorInRace> scoreCorrectionsByTeamName;

    public ScoreCorrectionForRaceImpl(Map<String, List<Util.Pair<String, Double>>> actResults, int raceNumberStartingWithZero) {
        this.raceNumberStartingWithOne = raceNumberStartingWithZero + 1;
        this.scoreCorrectionsByTeamName = new HashMap<String, RegattaScoreCorrections.ScoreCorrectionForCompetitorInRace>();
        for (Map.Entry<String, List<Util.Pair<String, Double>>> e : actResults.entrySet()) {
            String teamName = e.getKey();
            Util.Pair<String, Double> rankAndPoints = raceNumberStartingWithZero < e.getValue().size() ? e.getValue().get(raceNumberStartingWithZero) : null;
            this.scoreCorrectionsByTeamName.put(teamName, new ScoreCorrectionForCompetitorInRaceImpl(teamName, rankAndPoints));
        }
    }

    public String getRaceNameOrNumber() {
        return "" + this.raceNumberStartingWithOne;
    }

    public Set<String> getSailIDs() {
        return this.scoreCorrectionsByTeamName.keySet();
    }

    public RegattaScoreCorrections.ScoreCorrectionForCompetitorInRace getScoreCorrectionForCompetitor(String sailID) {
        return this.scoreCorrectionsByTeamName.get(sailID);
    }
}

