/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.mongodb.internal;

import com.mongodb.ClientSessionOptions;
import com.mongodb.ConnectionString;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import com.sap.sse.mongodb.AlreadyRegisteredException;
import com.sap.sse.mongodb.MongoDBConfiguration;
import com.sap.sse.mongodb.MongoDBService;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

public class MongoDBServiceImpl
implements MongoDBService {
    private static final Logger logger = Logger.getLogger(MongoDBServiceImpl.class.getName());
    private MongoDBConfiguration configuration;
    private final ConcurrentMap<ConnectionString, MongoClient> mongos = new ConcurrentHashMap<ConnectionString, MongoClient>();
    private final ConcurrentMap<ConnectionString, MongoDatabase> dbs = new ConcurrentHashMap<ConnectionString, MongoDatabase>();
    private final Map<ClientSession, Boolean> sessionsToRefresh;
    private Timer timerForSessionRefresh;
    private final Map<String, String> registered = new HashMap<String, String>();

    public MongoDBServiceImpl() {
        this.sessionsToRefresh = Collections.synchronizedMap(new WeakHashMap());
    }

    public MongoDBServiceImpl(MongoDBConfiguration configuration) {
        this();
        this.setConfiguration(configuration);
    }

    @Override
    public MongoDBConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MongoDBConfiguration configuration) {
        this.configuration = configuration;
        logger.info("Used Mongo configuration: " + configuration.getMongoClientURI());
    }

    @Override
    public MongoDatabase getDB() {
        this.ensureConfigurationDefaultingToTest();
        try {
            return this.getDB(this.configuration);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ClientSession startCausallyConsistentSession() {
        this.ensureConfigurationDefaultingToTest();
        return this.getMongo(this.getConfiguration()).startSession(ClientSessionOptions.builder().causallyConsistent(true).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientSession startAutoRefreshingSession() {
        this.ensureConfigurationDefaultingToTest();
        ClientSession result = this.getMongo(this.getConfiguration()).startSession();
        Map<ClientSession, Boolean> map = this.sessionsToRefresh;
        synchronized (map) {
            logger.fine("Adding session with ID " + result.getServerSession().getIdentifier() + " to set of sessions to refresh");
            this.sessionsToRefresh.put(result, true);
            this.ensureTimerRunning();
            this.timerForSessionRefresh.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Map map = MongoDBServiceImpl.this.sessionsToRefresh;
                    synchronized (map) {
                        if (MongoDBServiceImpl.this.sessionsToRefresh.isEmpty()) {
                            logger.fine("Terminating session refresh timer");
                            this.cancel();
                            MongoDBServiceImpl.this.timerForSessionRefresh.cancel();
                            MongoDBServiceImpl.this.timerForSessionRefresh = null;
                        } else {
                            BsonArray sessionIdsAsList = new BsonArray();
                            for (ClientSession session : MongoDBServiceImpl.this.sessionsToRefresh.keySet()) {
                                BsonDocument sessionId = session.getServerSession().getIdentifier();
                                sessionIdsAsList.add((BsonValue)sessionId);
                            }
                            logger.fine("Refreshing sessions " + sessionIdsAsList);
                            MongoDBServiceImpl.this.getDB().runCommand((Bson)new BsonDocument("refreshSessions", (BsonValue)sessionIdsAsList));
                        }
                    }
                }
            }, SESSION_REFERSH_INTERVAL.asMillis(), SESSION_REFERSH_INTERVAL.asMillis());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureTimerRunning() {
        Map<ClientSession, Boolean> map = this.sessionsToRefresh;
        synchronized (map) {
            if (this.timerForSessionRefresh == null) {
                logger.fine("Launching session refresh timer");
                this.timerForSessionRefresh = new Timer(true);
            }
        }
    }

    private void ensureConfigurationDefaultingToTest() {
        if (this.configuration == null) {
            this.configuration = MongoDBConfiguration.getDefaultTestConfiguration();
            logger.info("Used default Mongo configuration: " + this.configuration.getMongoClientURI());
        }
    }

    private synchronized MongoDatabase getDB(MongoDBConfiguration mongoDBConfiguration) throws UnknownHostException {
        ConnectionString connectionString = mongoDBConfiguration.getMongoClientURI();
        return this.dbs.computeIfAbsent(connectionString, k -> this.getMongo(mongoDBConfiguration).getDatabase(mongoDBConfiguration.getMongoClientURI().getDatabase()));
    }

    private MongoClient getMongo(MongoDBConfiguration mongoDBConfiguration) {
        return this.getMongo(mongoDBConfiguration.getMongoClientURI());
    }

    @Override
    public MongoClient getMongo(ConnectionString mongoConnectionString) {
        MongoClient mongo = this.mongos.computeIfAbsent(mongoConnectionString, k -> MongoClients.create((ConnectionString)mongoConnectionString));
        return mongo;
    }

    @Override
    public ConnectionString getMongoClientURI() {
        this.ensureConfigurationDefaultingToTest();
        return this.configuration.getMongoClientURI();
    }

    @Override
    public MongoClient getMongoClient() {
        this.ensureConfigurationDefaultingToTest();
        return this.getMongo(this.getConfiguration());
    }

    @Override
    public void registerExclusively(Class<?> registerForInterface, String collectionName) throws AlreadyRegisteredException {
        String fullyQualified = registerForInterface.getName();
        if (this.registered.keySet().contains(collectionName) && this.registered.get(collectionName) != fullyQualified) {
            logger.log(Level.SEVERE, "Same collection name (" + collectionName + " is required in two different places - this may lead to problems: \n" + " - already registered for: " + this.registered.get(collectionName) + "\n" + " - tried to register for: " + fullyQualified);
            throw new AlreadyRegisteredException();
        }
        logger.log(Level.INFO, "Registered collection name: " + collectionName);
        this.registered.put(collectionName, fullyQualified);
    }
}

