/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.mongodb;

import com.mongodb.ConnectionString;
import com.sap.sse.mongodb.MongoDBConfiguration;
import com.sap.sse.mongodb.MongoDBService;
import com.sap.sse.mongodb.internal.MongoDBServiceImpl;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(Activator.class.getName());

    public void start(BundleContext context) throws Exception {
        MongoDBConfiguration newConfiguration;
        MongoDBConfiguration defaultConfiguration = MongoDBConfiguration.getDefaultConfiguration();
        String mongoClientURI = context.getProperty("mongo.uri");
        if (mongoClientURI != null) {
            logger.info("found mongo.uri=" + mongoClientURI);
            newConfiguration = new MongoDBConfiguration(new ConnectionString(context.getProperty("mongo.uri")));
        } else {
            String hostName;
            String databaseName;
            String databaseNameProperty = context.getProperty("mongo.dbName");
            if (databaseNameProperty == null) {
                databaseName = defaultConfiguration.getMongoClientURI().getDatabase();
            } else {
                databaseName = databaseNameProperty;
                logger.log(Level.INFO, "found mongo.dbName=" + databaseName);
            }
            String hostNameFromProperty = context.getProperty("mongo.host");
            String[] primaryHostAndPort = ((String)defaultConfiguration.getMongoClientURI().getHosts().get(0)).split(":");
            if (hostNameFromProperty != null) {
                logger.log(Level.INFO, "found mongo.host=" + hostNameFromProperty);
                hostName = hostNameFromProperty;
            } else {
                hostName = ((String)defaultConfiguration.getMongoClientURI().getHosts().get(0)).split(":")[0];
            }
            if (context.getProperty("mongo.port") == null) {
                newConfiguration = primaryHostAndPort.length > 1 ? new MongoDBConfiguration(hostName, Integer.valueOf(primaryHostAndPort[1]), databaseName) : new MongoDBConfiguration(hostName, databaseName);
            } else {
                String portAsString = context.getProperty("mongo.port");
                logger.log(Level.INFO, "found mongo.port=" + portAsString);
                newConfiguration = new MongoDBConfiguration(hostName, Integer.valueOf(portAsString), databaseName);
            }
        }
        ((MongoDBServiceImpl)MongoDBService.INSTANCE).setConfiguration(newConfiguration);
    }

    public void stop(BundleContext context) throws Exception {
    }
}

