/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.BooleanFilter;
import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.filters.enums.SortOrder;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Item
extends Resource<Item> {
    public Item(String jsonStr) {
        super(jsonStr);
    }

    public Item(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String name() {
        return this.reqString("name");
    }

    public String description() {
        return this.optString("description");
    }

    public Status status() {
        return this.optEnum("status", Status.class);
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public String itemFamilyId() {
        return this.optString("item_family_id");
    }

    public Type type() {
        return this.reqEnum("type", Type.class);
    }

    public Boolean isShippable() {
        return this.optBoolean("is_shippable");
    }

    public Boolean isGiftable() {
        return this.reqBoolean("is_giftable");
    }

    public String redirectUrl() {
        return this.optString("redirect_url");
    }

    public Boolean enabledForCheckout() {
        return this.reqBoolean("enabled_for_checkout");
    }

    public Boolean enabledInPortal() {
        return this.reqBoolean("enabled_in_portal");
    }

    public Boolean includedInMrr() {
        return this.optBoolean("included_in_mrr");
    }

    public ItemApplicability itemApplicability() {
        return this.reqEnum("item_applicability", ItemApplicability.class);
    }

    public String giftClaimRedirectUrl() {
        return this.optString("gift_claim_redirect_url");
    }

    public String unit() {
        return this.optString("unit");
    }

    public Boolean metered() {
        return this.reqBoolean("metered");
    }

    public UsageCalculation usageCalculation() {
        return this.optEnum("usage_calculation", UsageCalculation.class);
    }

    public Timestamp archivedAt() {
        return this.optTimestamp("archived_at");
    }

    public List<ApplicableItem> applicableItems() {
        return this.optList("applicable_items", ApplicableItem.class);
    }

    public JSONObject metadata() {
        return this.optJSONObject("metadata");
    }

    public static CreateRequest create() {
        String uri = Item.uri("items");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static Request retrieve(String id) {
        String uri = Item.uri("items", Item.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static UpdateRequest update(String id) {
        String uri = Item.uri("items", Item.nullCheck(id));
        return new UpdateRequest(HttpUtil.Method.POST, uri);
    }

    public static ItemListRequest list() {
        String uri = Item.uri("items");
        return new ItemListRequest(uri);
    }

    public static Request delete(String id) {
        String uri = Item.uri("items", Item.nullCheck(id), "delete");
        return new Request(HttpUtil.Method.POST, uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ItemListRequest
    extends ListRequest<ItemListRequest> {
        private ItemListRequest(String uri) {
            super(uri);
        }

        public StringFilter<ItemListRequest> id() {
            return new StringFilter<ItemListRequest>("id", this).supportsMultiOperators(true);
        }

        public StringFilter<ItemListRequest> itemFamilyId() {
            return new StringFilter<ItemListRequest>("item_family_id", this).supportsMultiOperators(true);
        }

        public EnumFilter<Type, ItemListRequest> type() {
            return new EnumFilter<Type, ItemListRequest>("type", this);
        }

        public StringFilter<ItemListRequest> name() {
            return new StringFilter<ItemListRequest>("name", this);
        }

        public EnumFilter<ItemApplicability, ItemListRequest> itemApplicability() {
            return new EnumFilter<ItemApplicability, ItemListRequest>("item_applicability", this);
        }

        public EnumFilter<Status, ItemListRequest> status() {
            return new EnumFilter<Status, ItemListRequest>("status", this);
        }

        public BooleanFilter<ItemListRequest> isGiftable() {
            return new BooleanFilter<ItemListRequest>("is_giftable", this);
        }

        public TimestampFilter<ItemListRequest> updatedAt() {
            return new TimestampFilter<ItemListRequest>("updated_at", this);
        }

        public BooleanFilter<ItemListRequest> enabledForCheckout() {
            return new BooleanFilter<ItemListRequest>("enabled_for_checkout", this);
        }

        public BooleanFilter<ItemListRequest> enabledInPortal() {
            return new BooleanFilter<ItemListRequest>("enabled_in_portal", this);
        }

        public BooleanFilter<ItemListRequest> metered() {
            return new BooleanFilter<ItemListRequest>("metered", this);
        }

        public EnumFilter<UsageCalculation, ItemListRequest> usageCalculation() {
            return new EnumFilter<UsageCalculation, ItemListRequest>("usage_calculation", this);
        }

        public ItemListRequest sortByName(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "name");
            return this;
        }

        public ItemListRequest sortById(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "id");
            return this;
        }

        public ItemListRequest sortByUpdatedAt(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "updated_at");
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateRequest
    extends Request<UpdateRequest> {
        private UpdateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateRequest name(String name) {
            this.params.addOpt("name", name);
            return this;
        }

        public UpdateRequest description(String description) {
            this.params.addOpt("description", description);
            return this;
        }

        public UpdateRequest isShippable(Boolean isShippable) {
            this.params.addOpt("is_shippable", isShippable);
            return this;
        }

        public UpdateRequest itemFamilyId(String itemFamilyId) {
            this.params.addOpt("item_family_id", itemFamilyId);
            return this;
        }

        public UpdateRequest enabledInPortal(Boolean enabledInPortal) {
            this.params.addOpt("enabled_in_portal", enabledInPortal);
            return this;
        }

        public UpdateRequest redirectUrl(String redirectUrl) {
            this.params.addOpt("redirect_url", redirectUrl);
            return this;
        }

        public UpdateRequest enabledForCheckout(Boolean enabledForCheckout) {
            this.params.addOpt("enabled_for_checkout", enabledForCheckout);
            return this;
        }

        public UpdateRequest itemApplicability(ItemApplicability itemApplicability) {
            this.params.addOpt("item_applicability", (Object)itemApplicability);
            return this;
        }

        @Deprecated
        public UpdateRequest clearApplicableItems(Boolean clearApplicableItems) {
            this.params.addOpt("clear_applicable_items", clearApplicableItems);
            return this;
        }

        public UpdateRequest applicableItems(List<String> applicableItems) {
            this.params.addOpt("applicable_items", applicableItems);
            return this;
        }

        public UpdateRequest applicableItems(String ... applicableItems) {
            this.params.addOpt("applicable_items", applicableItems);
            return this;
        }

        public UpdateRequest unit(String unit) {
            this.params.addOpt("unit", unit);
            return this;
        }

        public UpdateRequest giftClaimRedirectUrl(String giftClaimRedirectUrl) {
            this.params.addOpt("gift_claim_redirect_url", giftClaimRedirectUrl);
            return this;
        }

        public UpdateRequest metadata(JSONObject metadata) {
            this.params.addOpt("metadata", metadata);
            return this;
        }

        public UpdateRequest includedInMrr(Boolean includedInMrr) {
            this.params.addOpt("included_in_mrr", includedInMrr);
            return this;
        }

        public UpdateRequest status(Status status) {
            this.params.addOpt("status", (Object)status);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest id(String id) {
            this.params.add("id", id);
            return this;
        }

        public CreateRequest name(String name) {
            this.params.add("name", name);
            return this;
        }

        public CreateRequest type(Type type) {
            this.params.add("type", (Object)type);
            return this;
        }

        public CreateRequest description(String description) {
            this.params.addOpt("description", description);
            return this;
        }

        public CreateRequest itemFamilyId(String itemFamilyId) {
            this.params.addOpt("item_family_id", itemFamilyId);
            return this;
        }

        public CreateRequest isGiftable(Boolean isGiftable) {
            this.params.addOpt("is_giftable", isGiftable);
            return this;
        }

        public CreateRequest isShippable(Boolean isShippable) {
            this.params.addOpt("is_shippable", isShippable);
            return this;
        }

        public CreateRequest enabledInPortal(Boolean enabledInPortal) {
            this.params.addOpt("enabled_in_portal", enabledInPortal);
            return this;
        }

        public CreateRequest redirectUrl(String redirectUrl) {
            this.params.addOpt("redirect_url", redirectUrl);
            return this;
        }

        public CreateRequest enabledForCheckout(Boolean enabledForCheckout) {
            this.params.addOpt("enabled_for_checkout", enabledForCheckout);
            return this;
        }

        public CreateRequest itemApplicability(ItemApplicability itemApplicability) {
            this.params.addOpt("item_applicability", (Object)itemApplicability);
            return this;
        }

        public CreateRequest applicableItems(List<String> applicableItems) {
            this.params.addOpt("applicable_items", applicableItems);
            return this;
        }

        public CreateRequest applicableItems(String ... applicableItems) {
            this.params.addOpt("applicable_items", applicableItems);
            return this;
        }

        public CreateRequest unit(String unit) {
            this.params.addOpt("unit", unit);
            return this;
        }

        public CreateRequest giftClaimRedirectUrl(String giftClaimRedirectUrl) {
            this.params.addOpt("gift_claim_redirect_url", giftClaimRedirectUrl);
            return this;
        }

        public CreateRequest includedInMrr(Boolean includedInMrr) {
            this.params.addOpt("included_in_mrr", includedInMrr);
            return this;
        }

        public CreateRequest metered(Boolean metered) {
            this.params.addOpt("metered", metered);
            return this;
        }

        public CreateRequest usageCalculation(UsageCalculation usageCalculation) {
            this.params.addOpt("usage_calculation", (Object)usageCalculation);
            return this;
        }

        public CreateRequest metadata(JSONObject metadata) {
            this.params.addOpt("metadata", metadata);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ApplicableItem
    extends Resource<ApplicableItem> {
        public ApplicableItem(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.optString("id");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UsageCalculation {
        SUM_OF_USAGES,
        LAST_USAGE,
        MAX_USAGE,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ItemApplicability {
        ALL,
        RESTRICTED,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        PLAN,
        ADDON,
        CHARGE,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        ACTIVE,
        ARCHIVED,
        DELETED,
        _UNKNOWN;

    }
}

