/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.enums.ValidationStatus;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gift
extends Resource<Gift> {
    public Gift(String jsonStr) {
        super(jsonStr);
    }

    public Gift(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public Status status() {
        return this.reqEnum("status", Status.class);
    }

    public Timestamp scheduledAt() {
        return this.optTimestamp("scheduled_at");
    }

    public Boolean autoClaim() {
        return this.reqBoolean("auto_claim");
    }

    public Boolean noExpiry() {
        return this.reqBoolean("no_expiry");
    }

    public Timestamp claimExpiryDate() {
        return this.optTimestamp("claim_expiry_date");
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public Gifter gifter() {
        return this.reqSubResource("gifter", Gifter.class);
    }

    public GiftReceiver giftReceiver() {
        return this.reqSubResource("gift_receiver", GiftReceiver.class);
    }

    public List<GiftTimeline> giftTimelines() {
        return this.optList("gift_timelines", GiftTimeline.class);
    }

    public static CreateRequest create() {
        String uri = Gift.uri("gifts");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static CreateForItemsRequest createForItems() {
        String uri = Gift.uri("gifts", "create_for_items");
        return new CreateForItemsRequest(HttpUtil.Method.POST, uri);
    }

    public static Request retrieve(String id) {
        String uri = Gift.uri("gifts", Gift.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static GiftListRequest list() {
        String uri = Gift.uri("gifts");
        return new GiftListRequest(uri);
    }

    public static Request claim(String id) {
        String uri = Gift.uri("gifts", Gift.nullCheck(id), "claim");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static Request cancel(String id) {
        String uri = Gift.uri("gifts", Gift.nullCheck(id), "cancel");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static UpdateGiftRequest updateGift(String id) {
        String uri = Gift.uri("gifts", Gift.nullCheck(id), "update_gift");
        return new UpdateGiftRequest(HttpUtil.Method.POST, uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateGiftRequest
    extends Request<UpdateGiftRequest> {
        private UpdateGiftRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateGiftRequest scheduledAt(Timestamp scheduledAt) {
            this.params.add("scheduled_at", scheduledAt);
            return this;
        }

        public UpdateGiftRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GiftListRequest
    extends ListRequest<GiftListRequest> {
        private GiftListRequest(String uri) {
            super(uri);
        }

        public EnumFilter<Status, GiftListRequest> status() {
            return new EnumFilter<Status, GiftListRequest>("status", this);
        }

        public StringFilter<GiftListRequest> giftReceiverEmail() {
            return new StringFilter<GiftListRequest>("gift_receiver[email]", this);
        }

        public StringFilter<GiftListRequest> gifterCustomerId() {
            return new StringFilter<GiftListRequest>("gifter[customer_id]", this);
        }

        public StringFilter<GiftListRequest> giftReceiverCustomerId() {
            return new StringFilter<GiftListRequest>("gift_receiver[customer_id]", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateForItemsRequest
    extends Request<CreateForItemsRequest> {
        private CreateForItemsRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateForItemsRequest scheduledAt(Timestamp scheduledAt) {
            this.params.addOpt("scheduled_at", scheduledAt);
            return this;
        }

        public CreateForItemsRequest autoClaim(Boolean autoClaim) {
            this.params.addOpt("auto_claim", autoClaim);
            return this;
        }

        public CreateForItemsRequest noExpiry(Boolean noExpiry) {
            this.params.addOpt("no_expiry", noExpiry);
            return this;
        }

        public CreateForItemsRequest claimExpiryDate(Timestamp claimExpiryDate) {
            this.params.addOpt("claim_expiry_date", claimExpiryDate);
            return this;
        }

        public CreateForItemsRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CreateForItemsRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CreateForItemsRequest gifterCustomerId(String gifterCustomerId) {
            this.params.add("gifter[customer_id]", gifterCustomerId);
            return this;
        }

        public CreateForItemsRequest gifterSignature(String gifterSignature) {
            this.params.add("gifter[signature]", gifterSignature);
            return this;
        }

        public CreateForItemsRequest gifterNote(String gifterNote) {
            this.params.addOpt("gifter[note]", gifterNote);
            return this;
        }

        public CreateForItemsRequest gifterPaymentSrcId(String gifterPaymentSrcId) {
            this.params.addOpt("gifter[payment_src_id]", gifterPaymentSrcId);
            return this;
        }

        public CreateForItemsRequest giftReceiverCustomerId(String giftReceiverCustomerId) {
            this.params.add("gift_receiver[customer_id]", giftReceiverCustomerId);
            return this;
        }

        public CreateForItemsRequest giftReceiverFirstName(String giftReceiverFirstName) {
            this.params.add("gift_receiver[first_name]", giftReceiverFirstName);
            return this;
        }

        public CreateForItemsRequest giftReceiverLastName(String giftReceiverLastName) {
            this.params.add("gift_receiver[last_name]", giftReceiverLastName);
            return this;
        }

        public CreateForItemsRequest giftReceiverEmail(String giftReceiverEmail) {
            this.params.add("gift_receiver[email]", giftReceiverEmail);
            return this;
        }

        public CreateForItemsRequest paymentIntentId(String paymentIntentId) {
            this.params.addOpt("payment_intent[id]", paymentIntentId);
            return this;
        }

        public CreateForItemsRequest paymentIntentGatewayAccountId(String paymentIntentGatewayAccountId) {
            this.params.addOpt("payment_intent[gateway_account_id]", paymentIntentGatewayAccountId);
            return this;
        }

        public CreateForItemsRequest paymentIntentGwToken(String paymentIntentGwToken) {
            this.params.addOpt("payment_intent[gw_token]", paymentIntentGwToken);
            return this;
        }

        public CreateForItemsRequest paymentIntentReferenceId(String paymentIntentReferenceId) {
            this.params.addOpt("payment_intent[reference_id]", paymentIntentReferenceId);
            return this;
        }

        @Deprecated
        public CreateForItemsRequest paymentIntentGwPaymentMethodId(String paymentIntentGwPaymentMethodId) {
            this.params.addOpt("payment_intent[gw_payment_method_id]", paymentIntentGwPaymentMethodId);
            return this;
        }

        public CreateForItemsRequest paymentIntentAdditionalInformation(JSONObject paymentIntentAdditionalInformation) {
            this.params.addOpt("payment_intent[additional_information]", paymentIntentAdditionalInformation);
            return this;
        }

        public CreateForItemsRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public CreateForItemsRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public CreateForItemsRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public CreateForItemsRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public CreateForItemsRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public CreateForItemsRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public CreateForItemsRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public CreateForItemsRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public CreateForItemsRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public CreateForItemsRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public CreateForItemsRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public CreateForItemsRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public CreateForItemsRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public CreateForItemsRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public CreateForItemsRequest subscriptionItemItemPriceId(int index, String subscriptionItemItemPriceId) {
            this.params.addOpt("subscription_items[item_price_id][" + index + "]", subscriptionItemItemPriceId);
            return this;
        }

        public CreateForItemsRequest subscriptionItemQuantity(int index, Integer subscriptionItemQuantity) {
            this.params.addOpt("subscription_items[quantity][" + index + "]", subscriptionItemQuantity);
            return this;
        }

        public CreateForItemsRequest subscriptionItemQuantityInDecimal(int index, String subscriptionItemQuantityInDecimal) {
            this.params.addOpt("subscription_items[quantity_in_decimal][" + index + "]", subscriptionItemQuantityInDecimal);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest scheduledAt(Timestamp scheduledAt) {
            this.params.addOpt("scheduled_at", scheduledAt);
            return this;
        }

        public CreateRequest autoClaim(Boolean autoClaim) {
            this.params.addOpt("auto_claim", autoClaim);
            return this;
        }

        public CreateRequest noExpiry(Boolean noExpiry) {
            this.params.addOpt("no_expiry", noExpiry);
            return this;
        }

        public CreateRequest claimExpiryDate(Timestamp claimExpiryDate) {
            this.params.addOpt("claim_expiry_date", claimExpiryDate);
            return this;
        }

        public CreateRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CreateRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CreateRequest gifterCustomerId(String gifterCustomerId) {
            this.params.add("gifter[customer_id]", gifterCustomerId);
            return this;
        }

        public CreateRequest gifterSignature(String gifterSignature) {
            this.params.add("gifter[signature]", gifterSignature);
            return this;
        }

        public CreateRequest gifterNote(String gifterNote) {
            this.params.addOpt("gifter[note]", gifterNote);
            return this;
        }

        public CreateRequest gifterPaymentSrcId(String gifterPaymentSrcId) {
            this.params.addOpt("gifter[payment_src_id]", gifterPaymentSrcId);
            return this;
        }

        public CreateRequest giftReceiverCustomerId(String giftReceiverCustomerId) {
            this.params.add("gift_receiver[customer_id]", giftReceiverCustomerId);
            return this;
        }

        public CreateRequest giftReceiverFirstName(String giftReceiverFirstName) {
            this.params.add("gift_receiver[first_name]", giftReceiverFirstName);
            return this;
        }

        public CreateRequest giftReceiverLastName(String giftReceiverLastName) {
            this.params.add("gift_receiver[last_name]", giftReceiverLastName);
            return this;
        }

        public CreateRequest giftReceiverEmail(String giftReceiverEmail) {
            this.params.add("gift_receiver[email]", giftReceiverEmail);
            return this;
        }

        public CreateRequest paymentIntentId(String paymentIntentId) {
            this.params.addOpt("payment_intent[id]", paymentIntentId);
            return this;
        }

        public CreateRequest paymentIntentGatewayAccountId(String paymentIntentGatewayAccountId) {
            this.params.addOpt("payment_intent[gateway_account_id]", paymentIntentGatewayAccountId);
            return this;
        }

        public CreateRequest paymentIntentGwToken(String paymentIntentGwToken) {
            this.params.addOpt("payment_intent[gw_token]", paymentIntentGwToken);
            return this;
        }

        public CreateRequest paymentIntentReferenceId(String paymentIntentReferenceId) {
            this.params.addOpt("payment_intent[reference_id]", paymentIntentReferenceId);
            return this;
        }

        @Deprecated
        public CreateRequest paymentIntentGwPaymentMethodId(String paymentIntentGwPaymentMethodId) {
            this.params.addOpt("payment_intent[gw_payment_method_id]", paymentIntentGwPaymentMethodId);
            return this;
        }

        public CreateRequest paymentIntentAdditionalInformation(JSONObject paymentIntentAdditionalInformation) {
            this.params.addOpt("payment_intent[additional_information]", paymentIntentAdditionalInformation);
            return this;
        }

        public CreateRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public CreateRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public CreateRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public CreateRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public CreateRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public CreateRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public CreateRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public CreateRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public CreateRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public CreateRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public CreateRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public CreateRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public CreateRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public CreateRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public CreateRequest subscriptionPlanId(String subscriptionPlanId) {
            this.params.add("subscription[plan_id]", subscriptionPlanId);
            return this;
        }

        public CreateRequest subscriptionPlanQuantity(Integer subscriptionPlanQuantity) {
            this.params.addOpt("subscription[plan_quantity]", subscriptionPlanQuantity);
            return this;
        }

        public CreateRequest subscriptionPlanQuantityInDecimal(String subscriptionPlanQuantityInDecimal) {
            this.params.addOpt("subscription[plan_quantity_in_decimal]", subscriptionPlanQuantityInDecimal);
            return this;
        }

        public CreateRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public CreateRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        public CreateRequest addonQuantityInDecimal(int index, String addonQuantityInDecimal) {
            this.params.addOpt("addons[quantity_in_decimal][" + index + "]", addonQuantityInDecimal);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GiftTimeline
    extends Resource<GiftTimeline> {
        public GiftTimeline(JSONObject jsonObj) {
            super(jsonObj);
        }

        public Status status() {
            return this.reqEnum("status", Status.class);
        }

        public Timestamp occurredAt() {
            return this.optTimestamp("occurred_at");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GiftReceiver
    extends Resource<GiftReceiver> {
        public GiftReceiver(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String customerId() {
            return this.reqString("customer_id");
        }

        public String subscriptionId() {
            return this.reqString("subscription_id");
        }

        public String firstName() {
            return this.optString("first_name");
        }

        public String lastName() {
            return this.optString("last_name");
        }

        public String email() {
            return this.optString("email");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Gifter
    extends Resource<Gifter> {
        public Gifter(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String customerId() {
            return this.reqString("customer_id");
        }

        public String invoiceId() {
            return this.optString("invoice_id");
        }

        public String signature() {
            return this.optString("signature");
        }

        public String note() {
            return this.optString("note");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        SCHEDULED,
        UNCLAIMED,
        CLAIMED,
        CANCELLED,
        EXPIRED,
        _UNKNOWN;

    }
}

